/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.base.decoration.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.moddingx.libx.base.decoration.DecoratedBlock;
import org.moddingx.libx.base.decoration.DecorationType;

public class DecoratedWoodBlock
extends RotatedPillarBlock {
    public final DecoratedBlock parent;
    @Nullable
    public final DecorationType<? extends Block> log;
    @Nullable
    public final DecorationType<? extends Block> stripped;

    public DecoratedWoodBlock(DecoratedBlock parent, @Nullable DecorationType<? extends Block> log, @Nullable DecorationType<? extends Block> stripped) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)parent));
        this.parent = parent;
        this.log = log;
        this.stripped = stripped;
    }

    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        this.parent.animateTick(state, level, pos, random);
    }

    public float getExplosionResistance() {
        return this.parent.getExplosionResistance();
    }

    public int getLightBlock(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return this.parent.getLightBlock(state, level, pos);
    }

    public int getLightEmission(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return this.parent.getLightEmission(state, world, pos);
    }

    @Nullable
    public BlockState getToolModifiedState(@Nonnull BlockState state, @Nonnull UseOnContext context, @Nonnull ItemAbility itemAbility, boolean simulate) {
        if (itemAbility == ItemAbilities.AXE_STRIP && this.stripped != null && this.parent.has(this.stripped)) {
            Block strippedBlock = this.parent.get(this.stripped);
            return (BlockState)strippedBlock.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)));
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    public boolean isEnabled(@Nonnull FeatureFlagSet enabledFeatures) {
        return this.parent.isEnabled(enabledFeatures);
    }
}

