/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.moddingx.libx.LibX;

public class BlockEntityUpdateQueue {
    private static final Map<ServerLevel, Set<BlockPos>> updateQueue = new HashMap<ServerLevel, Set<BlockPos>>();

    public static void scheduleUpdate(Level level, BlockPos pos) {
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!updateQueue.containsKey(serverLevel)) {
                updateQueue.put(serverLevel, new HashSet());
            }
            updateQueue.get(serverLevel).add(pos);
        }
    }

    public static void tick(ServerTickEvent.Post event) {
        for (Map.Entry<ServerLevel, Set<BlockPos>> entry : updateQueue.entrySet()) {
            for (BlockPos pos : entry.getValue()) {
                LibX.getNetwork().updateBE(entry.getKey(), pos);
            }
            entry.getValue().clear();
        }
    }
}

