/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.texture;

import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.LibX;
import org.moddingx.libx.mod.ModX;

public class Textures {
    private final ModX mod;
    private final Function<ResourceLocation, BufferedImage> textureLoader;
    private final int scale;
    private final Map<ResourceLocation, Pair<BufferedImage, Integer>> images;

    public Textures(ModX mod, Function<ResourceLocation, BufferedImage> textureLoader, int scale, Map<ResourceLocation, Pair<BufferedImage, Integer>> images) {
        this.mod = mod;
        this.textureLoader = textureLoader;
        this.scale = scale;
        this.images = Map.copyOf(images);
    }

    public int scale() {
        return this.scale;
    }

    public int textureScale(String loc) {
        return this.textureScale(this.mod.resource(loc));
    }

    public int imageScale(String loc) {
        return this.imageScale(this.mod.resource(loc));
    }

    public int textureScale(ResourceLocation loc) {
        return this.imageScale(ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("textures/" + loc.getPath() + ".png")));
    }

    public int imageScale(ResourceLocation loc) {
        if (this.images.containsKey(loc)) {
            return this.scale / (Integer)this.images.get(loc).getRight();
        }
        LibX.logger.warn("Requesting texture scale for " + String.valueOf(loc) + " after scale was built. It should be added to the texture builder.");
        return 1;
    }

    public BufferedImage texture(String loc) {
        return this.texture(this.mod.resource(loc));
    }

    public BufferedImage image(String loc) {
        return this.image(this.mod.resource(loc));
    }

    public BufferedImage texture(ResourceLocation loc) {
        return this.image(ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("textures/" + loc.getPath() + ".png")));
    }

    public BufferedImage image(ResourceLocation loc) {
        if (this.images.containsKey(loc)) {
            return (BufferedImage)this.images.get(loc).getLeft();
        }
        LibX.logger.warn("Loading texture " + String.valueOf(loc) + " after scale was built. It should be added to the texture builder.");
        return this.textureLoader.apply(loc);
    }
}

