/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.sandbox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockAgeProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.NopProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.Passthrough;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.provider.RegistryProviderBase;

public abstract class StructureProcessorProviderBase
extends RegistryProviderBase {
    protected StructureProcessorProviderBase(DatagenContext ctx) {
        super(ctx, DatagenStage.REGISTRY_SETUP);
    }

    @Override
    public final String getName() {
        return this.mod.modid + " structure processors";
    }

    public ProcessorListBuilder processor() {
        return new ProcessorListBuilder();
    }

    public static ProcessorRuleBuilder rule(Block block) {
        return StructureProcessorProviderBase.rule(block.defaultBlockState());
    }

    public static ProcessorRuleBuilder rule(Block block, RuleBlockEntityModifier modifier) {
        return StructureProcessorProviderBase.rule(block.defaultBlockState(), modifier);
    }

    public static ProcessorRuleBuilder rule(BlockState state) {
        return StructureProcessorProviderBase.rule(state, (RuleBlockEntityModifier)Passthrough.INSTANCE);
    }

    public static ProcessorRuleBuilder rule(BlockState state, RuleBlockEntityModifier modifier) {
        return new ProcessorRuleBuilder(state, modifier);
    }

    public class ProcessorListBuilder {
        private final List<StructureProcessor> processors = new ArrayList<StructureProcessor>();
        private final List<ProcessorRule> rules = new ArrayList<ProcessorRule>();

        private ProcessorListBuilder() {
        }

        public ProcessorListBuilder jigsaw() {
            return this.add(new StructureProcessor[]{JigsawReplacementProcessor.INSTANCE});
        }

        public ProcessorListBuilder keep(TagKey<Block> protectedBlocks) {
            return this.add(new StructureProcessor[]{new ProtectedBlockProcessor(protectedBlocks)});
        }

        public ProcessorListBuilder ignore(List<Block> ignoredBlocks) {
            return this.add(new StructureProcessor[]{new BlockIgnoreProcessor(List.copyOf(ignoredBlocks))});
        }

        public ProcessorListBuilder age(float mossProbability) {
            return this.add(new StructureProcessor[]{new BlockAgeProcessor(mossProbability)});
        }

        public ProcessorListBuilder addRule(ProcessorRule ... rules) {
            this.rules.addAll(Arrays.asList(rules));
            return this;
        }

        public ProcessorListBuilder addRules(Collection<ProcessorRule> rules) {
            this.rules.addAll(rules);
            return this;
        }

        public ProcessorListBuilder add(StructureProcessor ... processors) {
            this.rulesToProcessor();
            this.processors.addAll(Arrays.asList(processors));
            return this;
        }

        public ProcessorListBuilder addAll(Collection<StructureProcessor> processors) {
            this.rulesToProcessor();
            this.processors.addAll(processors);
            return this;
        }

        private void rulesToProcessor() {
            if (!this.rules.isEmpty()) {
                this.processors.add((StructureProcessor)new RuleProcessor(List.copyOf(this.rules)));
                this.rules.clear();
            }
        }

        public Holder<StructureProcessorList> build() {
            this.rulesToProcessor();
            if (this.processors.isEmpty()) {
                this.add(new StructureProcessor[]{NopProcessor.INSTANCE});
            }
            return StructureProcessorProviderBase.this.registries.writableRegistry(Registries.PROCESSOR_LIST).createIntrusiveHolder((Object)new StructureProcessorList(List.copyOf(this.processors)));
        }
    }

    public static class ProcessorRuleBuilder {
        private final BlockState output;
        private final RuleBlockEntityModifier modifier;
        private RuleTest templateState;
        private RuleTest worldState;
        private PosRuleTest location;

        private ProcessorRuleBuilder(BlockState output, RuleBlockEntityModifier modifier) {
            this.output = output;
            this.modifier = modifier;
            this.templateState = AlwaysTrueTest.INSTANCE;
            this.worldState = AlwaysTrueTest.INSTANCE;
            this.location = PosAlwaysTrueTest.INSTANCE;
        }

        public ProcessorRuleBuilder templateStateTest(RuleTest templateState) {
            this.templateState = templateState;
            return this;
        }

        public ProcessorRuleBuilder worldStateTest(RuleTest worldState) {
            this.worldState = worldState;
            return this;
        }

        public ProcessorRuleBuilder locationTest(PosRuleTest location) {
            this.location = location;
            return this;
        }

        public ProcessorRule build() {
            return new ProcessorRule(this.templateState, this.worldState, this.location, this.output, this.modifier);
        }
    }
}

