/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.sandbox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.provider.RegistryProviderBase;

public abstract class FeatureProviderBase
extends RegistryProviderBase {
    protected FeatureProviderBase(DatagenContext ctx) {
        super(ctx, DatagenStage.REGISTRY_SETUP);
    }

    @Override
    public final String getName() {
        return this.mod.modid + " features";
    }

    public Holder<ConfiguredFeature<?, ?>> feature(Feature<NoneFeatureConfiguration> feature) {
        return this.feature(feature, NoneFeatureConfiguration.INSTANCE);
    }

    public <C extends FeatureConfiguration> Holder<ConfiguredFeature<?, ?>> feature(Feature<C> feature, C config) {
        return this.registries.writableRegistry(Registries.CONFIGURED_FEATURE).createIntrusiveHolder((Object)new ConfiguredFeature(feature, config));
    }

    public <C extends CarverConfiguration> Holder<ConfiguredWorldCarver<?>> carver(WorldCarver<C> carver, C config) {
        return this.registries.writableRegistry(Registries.CONFIGURED_CARVER).createIntrusiveHolder((Object)new ConfiguredWorldCarver(carver, config));
    }

    public PlacementBuilder placement(Holder<ConfiguredFeature<?, ?>> feature) {
        return new PlacementBuilder(feature);
    }

    public ModifierBuilder modifiers() {
        return new ModifierBuilder();
    }

    public class PlacementBuilder
    extends AnyPlacementBuilder<Holder<PlacedFeature>> {
        private final Holder<ConfiguredFeature<?, ?>> feature;

        private PlacementBuilder(Holder<ConfiguredFeature<?, ?>> feature) {
            this.feature = feature;
        }

        @Override
        public Holder<PlacedFeature> build() {
            return FeatureProviderBase.this.registries.writableRegistry(Registries.PLACED_FEATURE).createIntrusiveHolder((Object)new PlacedFeature(this.feature, List.copyOf(this.modifiers)));
        }
    }

    public static class ModifierBuilder
    extends AnyPlacementBuilder<PlacementModifiers> {
        private ModifierBuilder() {
        }

        @Override
        public PlacementModifiers build() {
            return new PlacementModifiers(List.copyOf(this.modifiers));
        }
    }

    public static class PlacementModifiers {
        private final List<PlacementModifier> modifiers;

        public PlacementModifiers(List<PlacementModifier> modifiers) {
            this.modifiers = List.copyOf(modifiers);
        }
    }

    public static abstract class AnyPlacementBuilder<T> {
        protected final List<PlacementModifier> modifiers = new ArrayList<PlacementModifier>();

        private AnyPlacementBuilder() {
        }

        public AnyPlacementBuilder<T> count(int count) {
            if (count > 1) {
                return this.count((IntProvider)ConstantInt.of((int)count));
            }
            return this;
        }

        public AnyPlacementBuilder<T> count(int min, int max) {
            if (min == max) {
                return this.count(min);
            }
            return this.count((IntProvider)UniformInt.of((int)min, (int)max));
        }

        public AnyPlacementBuilder<T> count(IntProvider count) {
            return this.add(new PlacementModifier[]{CountPlacement.of((IntProvider)count)});
        }

        public AnyPlacementBuilder<T> countExtra(int base, float chance, int extra) {
            return this.add(PlacementUtils.countExtra((int)base, (float)chance, (int)extra));
        }

        public AnyPlacementBuilder<T> rarity(int avgOnceEveryChunk) {
            return this.add(new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)avgOnceEveryChunk)});
        }

        public AnyPlacementBuilder<T> noiseCount(int noiseToCount, double factor, double offset) {
            return this.add(new PlacementModifier[]{NoiseBasedCountPlacement.of((int)noiseToCount, (double)factor, (double)offset)});
        }

        public AnyPlacementBuilder<T> noiseThresholdCount(double noiseLevel, int above, int below) {
            return this.add(new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)noiseLevel, (int)above, (int)below)});
        }

        public AnyPlacementBuilder<T> spread() {
            return this.add(new PlacementModifier[]{InSquarePlacement.spread()});
        }

        public AnyPlacementBuilder<T> height(VerticalAnchor bottom, VerticalAnchor top) {
            return this.add(new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)bottom, (VerticalAnchor)top)});
        }

        public AnyPlacementBuilder<T> heightTriangle(VerticalAnchor bottom, VerticalAnchor top) {
            return this.add(new PlacementModifier[]{HeightRangePlacement.triangle((VerticalAnchor)bottom, (VerticalAnchor)top)});
        }

        public AnyPlacementBuilder<T> heightmap(Heightmap.Types type) {
            return this.add(new PlacementModifier[]{HeightmapPlacement.onHeightmap((Heightmap.Types)type)});
        }

        public AnyPlacementBuilder<T> biomeFilter() {
            return this.add(new PlacementModifier[]{BiomeFilter.biome()});
        }

        public AnyPlacementBuilder<T> validGround(TagKey<Block> tag) {
            return this.add(new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new Vec3i(0, -1, 0), tag), (BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.EMPTY})))});
        }

        public AnyPlacementBuilder<T> validGround(Block block) {
            return this.validGround(block.defaultBlockState());
        }

        public AnyPlacementBuilder<T> validGround(BlockState state) {
            return this.add(new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)state, (Vec3i)BlockPos.ZERO), (BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.EMPTY})))});
        }

        public AnyPlacementBuilder<T> waterDepth(int maxDepth) {
            return this.add(new PlacementModifier[]{SurfaceWaterDepthFilter.forMaxDepth((int)maxDepth)});
        }

        public AnyPlacementBuilder<T> inAir() {
            return this.add(new PlacementModifier[]{PlacementUtils.isEmpty()});
        }

        public AnyPlacementBuilder<T> add(PlacementModifiers modifiers) {
            return this.addAll(modifiers.modifiers);
        }

        public AnyPlacementBuilder<T> add(PlacementModifier ... modifiers) {
            this.modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        public AnyPlacementBuilder<T> addAll(Collection<PlacementModifier> modifiers) {
            this.modifiers.addAll(modifiers);
            return this;
        }

        public abstract T build();
    }
}

