/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.recipe.crafting;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.level.ItemLike;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;

public interface CompressionExtension
extends RecipeExtension {
    default public void compress(ItemLike item, ItemLike compressed) {
        this.compress(RecipeCategory.MISC, item, compressed);
    }

    default public void compress(ItemLike item, ItemLike compressed, boolean canRevert) {
        this.compress(RecipeCategory.MISC, item, compressed, canRevert);
    }

    default public void compress(RecipeCategory recipeCategory, ItemLike item, ItemLike compressed) {
        this.compress(recipeCategory, item, compressed, true);
    }

    default public void compress(RecipeCategory recipeCategory, ItemLike item, ItemLike compressed, boolean canRevert) {
        ShapedRecipeBuilder.shaped((RecipeCategory)recipeCategory, (ItemLike)compressed).define(Character.valueOf('a'), item).pattern("aaa").pattern("aaa").pattern("aaa").unlockedBy("has_item", this.criterion(item)).save(this.output(), this.provider().loc(item, "compress"));
        if (canRevert) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)recipeCategory, (ItemLike)item, (int)9).requires(compressed).unlockedBy("has_item", this.criterion(compressed)).save(this.output(), this.provider().loc(compressed, "decompress"));
        }
    }

    default public void smallCompress(ItemLike item, ItemLike compressed) {
        this.smallCompress(RecipeCategory.MISC, item, compressed);
    }

    default public void smallCompress(ItemLike item, ItemLike compressed, boolean canRevert) {
        this.smallCompress(RecipeCategory.MISC, item, compressed, canRevert);
    }

    default public void smallCompress(RecipeCategory recipeCategory, ItemLike item, ItemLike compressed) {
        this.smallCompress(recipeCategory, item, compressed, true);
    }

    default public void smallCompress(RecipeCategory recipeCategory, ItemLike item, ItemLike compressed, boolean canRevert) {
        ShapedRecipeBuilder.shaped((RecipeCategory)recipeCategory, (ItemLike)compressed).define(Character.valueOf('a'), item).pattern("aa").pattern("aa").unlockedBy("has_item", this.criterion(item)).save(this.output(), this.provider().loc(item, "small_compress"));
        if (canRevert) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)recipeCategory, (ItemLike)item, (int)4).requires(compressed).unlockedBy("has_item", this.criterion(compressed)).save(this.output(), this.provider().loc(compressed, "small_decompress"));
        }
    }

    default public void doubleCompress(ItemLike item, ItemLike compressed, ItemLike doubleCompressed) {
        this.doubleCompress(item, compressed, doubleCompressed, true);
    }

    default public void doubleCompress(ItemLike item, ItemLike compressed, ItemLike doubleCompressed, boolean canRevert) {
        this.compress(item, compressed, canRevert);
        this.compress(compressed, doubleCompressed, canRevert);
    }
}

