/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.model;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import org.moddingx.libx.LibX;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedButton;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedDoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedFenceBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedHangingSign;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedSign;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedTrapdoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedWallBlock;
import org.moddingx.libx.mod.ModX;

public abstract class ItemModelProviderBase
extends ItemModelProvider {
    public static final ResourceLocation GENERATED = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/generated");
    public static final ResourceLocation HANDHELD = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/handheld");
    public static final ResourceLocation DRIPPING_BUCKET = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"bucket_drip");
    public static final ResourceLocation SPECIAL_BLOCK_PARENT = LibX.getInstance().resource("item/base/special_block");
    public static final ResourceLocation SPAWN_EGG_PARENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/template_spawn_egg");
    public static final ResourceLocation FENCE_PARENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/fence_inventory");
    public static final ResourceLocation BUTTON_PARENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/button_inventory");
    public static final ResourceLocation WALL_PARENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/wall_inventory");
    protected final ModX mod;
    private final Set<Item> handheld = new HashSet<Item>();
    private final Set<Item> ignored = new HashSet<Item>();
    private final Set<Block> specialBlocks = new HashSet<Block>();

    public ItemModelProviderBase(DatagenContext ctx) {
        super(ctx.output(), ctx.mod().modid, ctx.fileHelper());
        this.mod = ctx.mod();
    }

    @Nonnull
    public final String getName() {
        return this.mod.modid + " item models";
    }

    protected void handheld(Item item) {
        this.handheld.add(item);
    }

    protected void manualModel(Item item) {
        this.ignored.add(item);
    }

    protected void specialBlock(Block block) {
        this.specialBlocks.add(block);
    }

    protected void registerModels() {
        this.setup();
        for (ResourceLocation id : BuiltInRegistries.ITEM.keySet().stream().sorted().toList()) {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (!this.mod.modid.equals(id.getNamespace()) || this.ignored.contains(item)) continue;
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                this.defaultBlock(id, blockItem);
                continue;
            }
            if (this.handheld.contains(item)) {
                ((ItemModelBuilder)this.withExistingParent(id.getPath(), HANDHELD)).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("item/" + id.getPath())));
                continue;
            }
            this.defaultItem(id, item);
        }
    }

    protected abstract void setup();

    protected void defaultItem(ResourceLocation id, Item item) {
        if (item instanceof SpawnEggItem) {
            this.withExistingParent(id.getPath(), SPAWN_EGG_PARENT);
        } else if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.getPath(), DRIPPING_BUCKET)).texture("base", this.modLoc("item/" + id.getPath()))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(bucketItem.content);
        } else {
            ((ItemModelBuilder)this.withExistingParent(id.getPath(), GENERATED)).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("item/" + id.getPath())));
        }
    }

    protected void defaultBlock(ResourceLocation id, BlockItem item) {
        if (this.specialBlocks.contains(item.getBlock())) {
            ((ItemModelBuilder)this.getBuilder(id.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(SPECIAL_BLOCK_PARENT));
        } else {
            Block block = item.getBlock();
            if (block instanceof DecoratedFenceBlock) {
                DecoratedFenceBlock decorated = (DecoratedFenceBlock)block;
                parentId = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent));
                ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)parentId.getNamespace(), (String)("block/" + parentId.getPath()));
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(FENCE_PARENT))).texture("texture", texture);
            } else {
                parentId = item.getBlock();
                if (parentId instanceof DecoratedButton) {
                    DecoratedButton decorated = (DecoratedButton)parentId;
                    parentId = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent));
                    ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)parentId.getNamespace(), (String)("block/" + parentId.getPath()));
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(BUTTON_PARENT))).texture("texture", texture);
                } else {
                    parentId = item.getBlock();
                    if (parentId instanceof DecoratedWallBlock) {
                        DecoratedWallBlock decorated = (DecoratedWallBlock)parentId;
                        parentId = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent));
                        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)parentId.getNamespace(), (String)("block/" + parentId.getPath()));
                        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(WALL_PARENT))).texture("wall", texture);
                    } else if (item.getBlock() instanceof DecoratedTrapdoorBlock) {
                        ((ItemModelBuilder)this.getBuilder(id.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("block/" + id.getPath() + "_bottom"))));
                    } else if (item.getBlock() instanceof DecoratedDoorBlock || item.getBlock() instanceof DecoratedSign.Standing || item.getBlock() instanceof DecoratedSign.Wall || item.getBlock() instanceof DecoratedHangingSign.Ceiling || item.getBlock() instanceof DecoratedHangingSign.Wall) {
                        ((ItemModelBuilder)this.withExistingParent(id.getPath(), GENERATED)).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("item/" + id.getPath())));
                    } else {
                        ((ItemModelBuilder)this.getBuilder(id.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("block/" + id.getPath()))));
                    }
                }
            }
        }
    }
}

