/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.loot.entry;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.moddingx.libx.datagen.provider.loot.entry.GenericLootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.LootFactory;
import org.moddingx.libx.datagen.provider.loot.entry.LootModifier;

@FunctionalInterface
public interface SimpleLootFactory<T>
extends LootFactory<T> {
    public static <T> SimpleLootFactory<T> from(LootPoolSingletonContainer.Builder<?> builder) {
        return item -> builder;
    }

    @Override
    public LootPoolSingletonContainer.Builder<?> build(T var1);

    default public LootFactory<T> withFinal(GenericLootModifier<T> finalModifier) {
        return b -> finalModifier.apply(b, this.build((T)b));
    }

    default public SimpleLootFactory<T> with(LootModifier<T> ... modifiers) {
        return this.with(Arrays.stream(modifiers).toList());
    }

    default public SimpleLootFactory<T> with(List<LootModifier<T>> modifiers) {
        if (modifiers.isEmpty()) {
            return this;
        }
        LootModifier chained = LootModifier.chain(modifiers.get(0).element(), modifiers);
        return b -> chained.apply(b, this.build((T)b));
    }

    @Override
    default public SimpleLootFactory<T> with(LootItemCondition.Builder ... conditions) {
        return b -> {
            LootPoolSingletonContainer.Builder<?> entry = this.build((T)b);
            for (LootItemCondition.Builder condition : conditions) {
                entry.when(condition);
            }
            return entry;
        };
    }

    default public SimpleLootFactory<T> with(LootItemConditionalFunction.Builder<?> ... functions) {
        return item -> {
            LootPoolSingletonContainer.Builder entry = this.build((T)item);
            for (LootItemConditionalFunction.Builder function : functions) {
                entry = entry.apply((LootItemFunction.Builder)function);
            }
            return entry;
        };
    }
}

