/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.loot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.loot.LootBuilders;
import org.moddingx.libx.datagen.provider.loot.LootProviderBase;
import org.moddingx.libx.datagen.provider.loot.entry.GenericLootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.LootFactory;
import org.moddingx.libx.datagen.provider.loot.entry.LootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.SimpleLootFactory;
import org.moddingx.libx.impl.loot.CopyBlockEntityDataFunction;

public abstract class BlockLootProviderBase
extends LootProviderBase<Block> {
    protected BlockLootProviderBase(DatagenContext ctx) {
        super(ctx, "blocks", LootContextParamSets.BLOCK, Registries.BLOCK);
    }

    @Override
    @Nullable
    protected LootTable.Builder defaultBehavior(Block block) {
        if (block.getStateDefinition().getPossibleStates().stream().anyMatch(this::needsLootTable)) {
            LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)block);
            LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry).when(ExplosionCondition.survivesExplosion());
            if (block.defaultBlockState().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                pool = pool.when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)));
            }
            if (block.defaultBlockState().hasProperty((Property)BlockStateProperties.BED_PART)) {
                pool = pool.when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.HEAD)));
            }
            return LootTable.lootTable().withPool(pool);
        }
        return null;
    }

    protected boolean needsLootTable(BlockState state) {
        return !state.isAir() && state.getFluidState().createLegacyBlock().getBlock() != state.getBlock() && !BuiltInLootTables.EMPTY.equals(state.getBlock().getLootTable());
    }

    @Override
    public void generateBaseTable(Block block, LootPoolEntryContainer.Builder<?> entry) {
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(entry).when(ExplosionCondition.survivesExplosion());
        this.customLootTable(block, LootTable.lootTable().withPool(pool));
    }

    @Override
    protected SimpleLootFactory<Block> element() {
        return LootItem::lootTableItem;
    }

    @Override
    public void drops(Block block, ItemStack ... drops) {
        this.drops(block, true, drops);
    }

    @Override
    public void drops(Block block, List<LootFactory<Block>> loot) {
        this.drops(block, true, loot);
    }

    public void drops(Block block, boolean silkTouch, ItemStack ... drops) {
        this.drops(block, silkTouch ? this.silk(this.identity()) : this.noSilk(), drops);
    }

    @SafeVarargs
    public final void drops(Block block, boolean silkTouch, LootFactory<Block> ... drops) {
        this.drops(block, silkTouch, Arrays.stream(drops).toList());
    }

    public void drops(Block block, boolean silkTouch, List<LootFactory<Block>> drops) {
        this.drops(block, silkTouch ? this.silk(this.identity()) : this.noSilk(), drops);
    }

    public void drops(Block block, SilkModifier silkTouch, ItemStack ... drops) {
        this.drops(block, silkTouch, Arrays.stream(drops).map(this::stack).toList());
    }

    @SafeVarargs
    public final void drops(Block block, SilkModifier silkTouch, LootFactory<Block> ... drops) {
        this.drops(block, silkTouch, Arrays.stream(drops).toList());
    }

    public void drops(Block block, SilkModifier silkTouch, List<LootFactory<Block>> drops) {
        LootPoolEntryContainer.Builder<?> entry = this.combine(drops).build(block);
        if (silkTouch.modifier != null) {
            LootPoolEntryContainer.Builder silkBuilder = silkTouch.modifier.apply(block, this.element().build(block)).when(this.silkCondition());
            entry = LootBuilders.alternative(List.of(silkBuilder, entry));
        }
        this.generateBaseTable(block, entry);
    }

    public SilkModifier silk(GenericLootModifier<Block> modifier) {
        return new SilkModifier(modifier);
    }

    public SilkModifier noSilk() {
        return new SilkModifier(null);
    }

    public LootModifier<Block> fortuneOres() {
        return this.modifier((block, entry) -> entry.apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount(this.holder(Enchantments.FORTUNE))));
    }

    public LootModifier<Block> fortuneUniform() {
        return this.fortuneUniform(1);
    }

    public LootModifier<Block> fortuneUniform(int multiplier) {
        return this.modifier((block, entry) -> entry.apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount(this.holder(Enchantments.FORTUNE), (int)multiplier)));
    }

    public LootModifier<Block> fortuneBinomial(float probability) {
        return this.fortuneBinomial(probability, 0);
    }

    public LootModifier<Block> fortuneBinomial(float probability, int bonus) {
        return this.modifier((block, entry) -> entry.apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount(this.holder(Enchantments.FORTUNE), (float)probability, (int)bonus)));
    }

    public LootItemCondition.Builder randomFortune(float baseChance) {
        return this.randomFortune(baseChance, baseChance * 1.1111112f, baseChance * 1.25f, baseChance * 1.6666666f, baseChance * 5.0f);
    }

    public LootItemCondition.Builder randomFortune(float baseChance, float ... levelChances) {
        float[] chances = new float[levelChances.length + 1];
        chances[0] = baseChance;
        System.arraycopy(levelChances, 0, chances, 1, levelChances.length);
        return BonusLevelTableCondition.bonusLevelFlatChance(this.holder(Enchantments.FORTUNE), (float[])chances);
    }

    public MatchToolBuilder matchTool(ItemLike item) {
        return new MatchToolBuilder(ItemPredicate.Builder.item().of(new ItemLike[]{item}));
    }

    public MatchToolBuilder matchTool(TagKey<Item> item) {
        return new MatchToolBuilder(ItemPredicate.Builder.item().of(item));
    }

    public MatchStateBuilder matchState() {
        return new MatchStateBuilder(StatePropertiesPredicate.Builder.properties());
    }

    public LootItemCondition.Builder silkCondition() {
        ItemPredicate.Builder predicate = ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate(this.holder(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.ANY))));
        return MatchTool.toolMatches((ItemPredicate.Builder)predicate);
    }

    public LootModifier<Block> copyNBT(String ... tags) {
        return this.modifier((block, entry) -> {
            CopyBlockEntityDataFunction.Builder func = CopyBlockEntityDataFunction.copyBlockEntityData(block, Set.of(tags));
            return entry.apply((LootItemFunction.Builder)func);
        });
    }

    public LootModifier<Block> copyProperties(Property<?> ... properties) {
        return this.modifier((block, entry) -> {
            CopyBlockState.Builder func = CopyBlockState.copyState((Block)block);
            for (Property property : properties) {
                func = func.copy(property);
            }
            return entry.apply((LootItemFunction.Builder)func);
        });
    }

    public static class SilkModifier {
        @Nullable
        public final GenericLootModifier<Block> modifier;

        private SilkModifier(@Nullable GenericLootModifier<Block> modifier) {
            this.modifier = modifier;
        }
    }

    public class MatchToolBuilder
    implements LootItemCondition.Builder {
        private final ItemPredicate.Builder builder;
        private final List<EnchantmentPredicate> enchantments;

        private MatchToolBuilder(ItemPredicate.Builder builder) {
            this.builder = builder;
            this.enchantments = new ArrayList<EnchantmentPredicate>();
        }

        @Nonnull
        public LootItemCondition build() {
            if (!this.enchantments.isEmpty()) {
                this.builder.withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.copyOf(this.enchantments)));
                this.enchantments.clear();
            }
            return MatchTool.toolMatches((ItemPredicate.Builder)this.builder).build();
        }

        public MatchToolBuilder enchantment(ResourceKey<Enchantment> enchantment) {
            return this.enchantment(enchantment, MinMaxBounds.Ints.ANY);
        }

        public MatchToolBuilder enchantment(ResourceKey<Enchantment> enchantment, int minLevel) {
            return this.enchantment(enchantment, MinMaxBounds.Ints.atLeast((int)minLevel));
        }

        public MatchToolBuilder enchantmentExact(ResourceKey<Enchantment> enchantment, int level) {
            return this.enchantment(enchantment, MinMaxBounds.Ints.exactly((int)level));
        }

        private MatchToolBuilder enchantment(ResourceKey<Enchantment> enchantment, MinMaxBounds.Ints bounds) {
            this.enchantments.add(new EnchantmentPredicate(BlockLootProviderBase.this.holder(enchantment), bounds));
            return this;
        }

        public <T extends ItemSubPredicate> MatchToolBuilder setSubPredicate(ItemSubPredicate.Type<T> type, T predicate) {
            if (type == ItemSubPredicates.ENCHANTMENTS) {
                throw new IllegalArgumentException("Use MatchToolBuilder#enchantment");
            }
            this.builder.withSubPredicate(type, predicate);
            return this;
        }
    }

    public class MatchStateBuilder
    implements GenericLootModifier<Block> {
        private final StatePropertiesPredicate.Builder builder;

        private MatchStateBuilder(StatePropertiesPredicate.Builder builder) {
            this.builder = builder;
        }

        @Override
        public LootPoolEntryContainer.Builder<?> apply(Block item, LootPoolSingletonContainer.Builder<?> entry) {
            return entry.when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)item).setProperties(this.builder));
        }

        @Override
        public SimpleLootFactory<Block> element() {
            return BlockLootProviderBase.this.element();
        }

        public MatchStateBuilder hasProperty(Property<?> property, String value) {
            this.builder.hasProperty(property, value);
            return this;
        }

        public MatchStateBuilder hasProperty(Property<Integer> property, int value) {
            this.builder.hasProperty(property, value);
            return this;
        }

        public MatchStateBuilder hasProperty(Property<Boolean> property, boolean value) {
            this.builder.hasProperty(property, value);
            return this;
        }

        public <T extends Comparable<T> & StringRepresentable> MatchStateBuilder hasProperty(Property<T> property, T value) {
            this.builder.hasProperty(property, value);
            return this;
        }
    }
}

