/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.registries.holdersets.AndHolderSet;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;
import net.neoforged.neoforge.registries.holdersets.NotHolderSet;
import net.neoforged.neoforge.registries.holdersets.OrHolderSet;
import org.moddingx.libx.LibX;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.RegistryProvider;
import org.moddingx.libx.datagen.RegistrySet;
import org.moddingx.libx.datagen.provider.Id;
import org.moddingx.libx.mod.ModX;

public abstract class RegistryProviderBase
implements RegistryProvider {
    protected final ModX mod;
    protected final RegistrySet registries;
    protected final DatagenContext context;

    protected RegistryProviderBase(DatagenContext ctx, DatagenStage requiredStage) {
        this.mod = ctx.mod();
        this.registries = ctx.registries();
        this.context = ctx;
        if (ctx.stage() != requiredStage) {
            throw new IllegalStateException("Invalid stage: Provider '" + this.getName() + "' must run on " + String.valueOf((Object)requiredStage) + " stage.");
        }
    }

    public final <T> Holder.Reference<T> holder(ResourceKey<T> key) {
        Registry registry = this.registries.registry(ResourceKey.createRegistryKey((ResourceLocation)key.registry()));
        return (Holder.Reference)registry.getHolder(key).orElseThrow(() -> new IllegalArgumentException("Unregistered element in registry " + String.valueOf(key.registry()) + ": " + String.valueOf(key.location())));
    }

    public final <T> Holder.Reference<T> holder(ResourceKey<? extends Registry<T>> registryKey, T value) {
        Registry registry = this.registries.registry(registryKey);
        return registry.getResourceKey(value).map(this::holder).orElseThrow(() -> new IllegalArgumentException("Unregistered element in registry " + String.valueOf(registryKey.location()) + ": " + String.valueOf(value)));
    }

    @SafeVarargs
    public final <T> HolderSet<T> set(Holder<T> ... elements) {
        return HolderSet.direct(elements);
    }

    public final <T> HolderSet<T> set(TagKey<T> tag) {
        Registry registry = this.registries.registry(tag.registry());
        return registry.getOrCreateTag(tag);
    }

    public final <T> HolderSet<T> any(ResourceKey<? extends Registry<T>> registryKey) {
        return new AnyHolderSet(this.registries.registry(registryKey).asLookup());
    }

    public final <T> HolderSet<T> not(TagKey<T> tag) {
        return new NotHolderSet(this.registries.registry(tag.registry()).asLookup(), this.set(tag));
    }

    public final <T> HolderSet<T> not(ResourceKey<? extends Registry<T>> registryKey, HolderSet<T> set) {
        return new NotHolderSet(this.registries.registry(registryKey).asLookup(), set);
    }

    public final <T> HolderSet<T> and(TagKey<T> a, TagKey<T> b) {
        return this.and(this.set(a), this.set(b));
    }

    public final <T> HolderSet<T> and(TagKey<T> a, HolderSet<T> b) {
        return this.and(this.set(a), b);
    }

    public final <T> HolderSet<T> and(HolderSet<T> a, TagKey<T> b) {
        return this.and(a, this.set(b));
    }

    @SafeVarargs
    public final <T> HolderSet<T> and(HolderSet<T> ... sets) {
        return new AndHolderSet(List.of(sets));
    }

    public final <T> HolderSet<T> or(TagKey<T> a, TagKey<T> b) {
        return this.and(this.set(a), this.set(b));
    }

    public final <T> HolderSet<T> or(TagKey<T> a, HolderSet<T> b) {
        return this.and(this.set(a), b);
    }

    public final <T> HolderSet<T> or(HolderSet<T> a, TagKey<T> b) {
        return this.and(a, this.set(b));
    }

    @SafeVarargs
    public final <T> HolderSet<T> or(HolderSet<T> ... sets) {
        return new OrHolderSet(List.of(sets));
    }

    @Override
    public void run() {
        this.registerFields();
    }

    protected final void registerFields() {
        try {
            for (Field field : this.getClass().getFields()) {
                if (field.getDeclaringClass() != this.getClass() || !Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !Holder.class.isAssignableFrom(field.getType())) continue;
                Holder value = (Holder)field.get(this);
                if (value instanceof Holder.Reference) {
                    String id;
                    Holder.Reference ref = (Holder.Reference)value;
                    if (ref.type == Holder.Reference.Type.INTRUSIVE && !ref.isBound()) {
                        ResourceKey registryKey = this.registries.findRegistryFor(ref);
                        if (registryKey == null) {
                            throw new IllegalStateException("Can't infer target registry for " + field.getName() + " in '" + this.getName() + "'. Was the holder created properly?");
                        }
                        Id idObj = field.getAnnotation(Id.class);
                        if (idObj != null) {
                            id = ResourceLocation.fromNamespaceAndPath((String)(idObj.namespace().isEmpty() ? this.mod.modid : idObj.namespace()), (String)idObj.value());
                        } else {
                            StringBuilder sb = new StringBuilder();
                            for (char chr : field.getName().toCharArray()) {
                                if (Character.isUpperCase(chr)) {
                                    sb.append('_');
                                }
                                sb.append(Character.toLowerCase(chr));
                            }
                            id = ResourceLocation.fromNamespaceAndPath((String)this.mod.modid, (String)sb.toString());
                        }
                        this.registries.writableRegistry(registryKey).register(ResourceKey.create(registryKey, (ResourceLocation)id), ref.value(), RegistrationInfo.BUILT_IN);
                        continue;
                    }
                    if (field.getAnnotation(Id.class) == null) continue;
                    Id idObj = field.getAnnotation(Id.class);
                    id = (idObj.namespace().isEmpty() ? this.mod.modid : idObj.namespace()) + ":" + idObj.value();
                    LibX.logger.warn("Skipping bound holder " + field.getName() + " with explicit id " + id + " in '" + this.getName() + "'");
                    continue;
                }
                LibX.logger.warn("Skipping direct holder in '" + this.getName() + "' (from " + field.getName() + ")");
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to register element for provider '" + this.getName() + "'", e);
        }
    }
}

