/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider;

import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.provider.RegistryProviderBase;

public abstract class DamageTypeProviderBase
extends RegistryProviderBase {
    public DamageTypeProviderBase(DatagenContext ctx) {
        super(ctx, DatagenStage.REGISTRY_SETUP);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.mod.modid + " damage types";
    }

    public DamageTypeBuilder damageType(String msgId, float exhaustion) {
        return new DamageTypeBuilder(msgId, exhaustion);
    }

    public class DamageTypeBuilder {
        private final String msgId;
        private final float exhaustion;
        private DamageScaling scaling = DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
        private DamageEffects effects = DamageEffects.HURT;
        private DeathMessageType deathMessageType = DeathMessageType.DEFAULT;

        private DamageTypeBuilder(String msgId, float exhaustion) {
            this.msgId = msgId;
            this.exhaustion = exhaustion;
        }

        public DamageTypeBuilder scaling(DamageScaling scaling) {
            this.scaling = scaling;
            return this;
        }

        public DamageTypeBuilder effects(DamageEffects effects) {
            this.effects = effects;
            return this;
        }

        public DamageTypeBuilder deathMessageType(DeathMessageType deathMessageType) {
            this.deathMessageType = deathMessageType;
            return this;
        }

        public Holder<DamageType> build() {
            DamageType damageType = new DamageType(this.msgId, this.scaling, this.exhaustion, this.effects, this.deathMessageType);
            return DamageTypeProviderBase.this.registries.writableRegistry(Registries.DAMAGE_TYPE).createIntrusiveHolder((Object)damageType);
        }
    }
}

