/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.loot;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.SequentialEntry;
import org.moddingx.libx.impl.loot.AllLootEntry;

public class LootBuilders {
    public static LootPoolEntryContainer.Builder<?> all(List<LootPoolEntryContainer.Builder<?>> entries) {
        return new AllLootBuilder(entries.toArray(new LootPoolEntryContainer.Builder[0]));
    }

    public static LootPoolEntryContainer.Builder<?> group(List<LootPoolEntryContainer.Builder<?>> entries) {
        return new GroupLootBuilder(entries.toArray(new LootPoolEntryContainer.Builder[0]));
    }

    public static LootPoolEntryContainer.Builder<?> alternative(List<LootPoolEntryContainer.Builder<?>> entries) {
        return AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])entries.toArray(new LootPoolEntryContainer.Builder[0]));
    }

    public static LootPoolEntryContainer.Builder<?> sequence(List<LootPoolEntryContainer.Builder<?>> entries) {
        return new SequenceLootBuilder(entries.toArray(new LootPoolEntryContainer.Builder[0]));
    }

    private static class AllLootBuilder
    extends LootPoolEntryContainer.Builder<AllLootBuilder> {
        private final List<LootPoolEntryContainer> lootEntries = new ArrayList<LootPoolEntryContainer>();

        public AllLootBuilder(LootPoolEntryContainer.Builder<?> ... entries) {
            for (LootPoolEntryContainer.Builder<?> builder : entries) {
                this.lootEntries.add(builder.build());
            }
        }

        @Nonnull
        protected AllLootBuilder getThis() {
            return this;
        }

        public AllLootBuilder add(LootPoolEntryContainer.Builder<?> entry) {
            this.lootEntries.add(entry.build());
            return this;
        }

        @Nonnull
        public LootPoolEntryContainer build() {
            return new AllLootEntry(List.copyOf(this.lootEntries), this.getConditions());
        }
    }

    private static class GroupLootBuilder
    extends LootPoolEntryContainer.Builder<GroupLootBuilder> {
        private final List<LootPoolEntryContainer> lootEntries = new ArrayList<LootPoolEntryContainer>();

        public GroupLootBuilder(LootPoolEntryContainer.Builder<?> ... entries) {
            for (LootPoolEntryContainer.Builder<?> builder : entries) {
                this.lootEntries.add(builder.build());
            }
        }

        @Nonnull
        protected GroupLootBuilder getThis() {
            return this;
        }

        public GroupLootBuilder add(LootPoolEntryContainer.Builder<?> entry) {
            this.lootEntries.add(entry.build());
            return this;
        }

        @Nonnull
        public LootPoolEntryContainer build() {
            return new EntryGroup(List.copyOf(this.lootEntries), this.getConditions());
        }
    }

    private static class SequenceLootBuilder
    extends LootPoolEntryContainer.Builder<SequenceLootBuilder> {
        private final List<LootPoolEntryContainer> lootEntries = new ArrayList<LootPoolEntryContainer>();

        public SequenceLootBuilder(LootPoolEntryContainer.Builder<?> ... entries) {
            for (LootPoolEntryContainer.Builder<?> builder : entries) {
                this.lootEntries.add(builder.build());
            }
        }

        @Nonnull
        protected SequenceLootBuilder getThis() {
            return this;
        }

        public SequenceLootBuilder add(LootPoolEntryContainer.Builder<?> entry) {
            this.lootEntries.add(entry.build());
            return this;
        }

        @Nonnull
        public LootPoolEntryContainer build() {
            return new SequentialEntry(List.copyOf(this.lootEntries), this.getConditions());
        }
    }
}

