/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.crafting.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.apache.commons.lang3.stream.Streams;

public class EffectIngredient
implements ICustomIngredient {
    public static final MapCodec<EffectIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(ei -> Objects.requireNonNullElse(ei.potionItem, Items.AIR)), (App)MobEffectInstance.CODEC.listOf().fieldOf("effects").forGetter(ei -> ei.effects), (App)Codec.BOOL.fieldOf("allows_extra_effects").orElse((Object)false).forGetter(ei -> ei.extraEffects), (App)Codec.BOOL.fieldOf("allows_higher_amplifier").orElse((Object)true).forGetter(ei -> ei.higherAmplifier), (App)Codec.BOOL.fieldOf("allows_higher_duration").orElse((Object)true).forGetter(ei -> ei.higherDuration)).apply((Applicative)instance, EffectIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EffectIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), ei -> ei.potionItem, (StreamCodec)ByteBufCodecs.list().apply(MobEffectInstance.STREAM_CODEC), ei -> ei.effects, (StreamCodec)ByteBufCodecs.BOOL, ei -> ei.extraEffects, (StreamCodec)ByteBufCodecs.BOOL, ei -> ei.higherAmplifier, (StreamCodec)ByteBufCodecs.BOOL, ei -> ei.higherDuration, EffectIngredient::new);
    public static final IngredientType<EffectIngredient> TYPE = new IngredientType(CODEC, STREAM_CODEC);
    @Nullable
    public final Item potionItem;
    public final List<MobEffectInstance> effects;
    public final boolean extraEffects;
    public final boolean higherAmplifier;
    public final boolean higherDuration;

    public EffectIngredient(ItemStack potionStack) {
        this(potionStack.getItem(), EffectIngredient.getEffects(potionStack), false, true, true);
    }

    public EffectIngredient(ItemStack potionStack, boolean extraEffects, boolean higherAmplifier, boolean higherDuration) {
        this(potionStack.getItem(), EffectIngredient.getEffects(potionStack), extraEffects, higherAmplifier, higherDuration);
    }

    public EffectIngredient(@Nullable Item potionItem, List<MobEffectInstance> effects) {
        this(potionItem, effects, false, true, true);
    }

    public EffectIngredient(@Nullable Item potionItem, List<MobEffectInstance> effects, boolean extraEffects, boolean higherAmplifier, boolean higherDuration) {
        this(potionItem, effects.stream(), extraEffects, higherAmplifier, higherDuration);
    }

    private EffectIngredient(@Nullable Item potionItem, Stream<MobEffectInstance> effects, boolean extraEffects, boolean higherAmplifier, boolean higherDuration) {
        this.potionItem = potionItem;
        this.effects = effects.map(MobEffectInstance::new).toList();
        this.extraEffects = extraEffects;
        this.higherAmplifier = higherAmplifier;
        this.higherDuration = higherDuration;
    }

    @Nonnull
    public IngredientType<?> getType() {
        return TYPE;
    }

    @Nonnull
    public Stream<ItemStack> getItems() {
        ItemStack potion = new ItemStack((ItemLike)(this.potionItem == null ? Items.POTION : this.potionItem));
        PotionContents potionContents = new PotionContents(Optional.empty(), Optional.empty(), this.effects.stream().map(MobEffectInstance::new).toList());
        potion.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        return Stream.of(potion);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (!(stack == null || stack.isEmpty() || this.potionItem != null && stack.getItem() != this.potionItem)) {
            ArrayList<MobEffectInstance> effectsLeft = new ArrayList<MobEffectInstance>(EffectIngredient.getEffects(stack).toList());
            for (MobEffectInstance effect : this.effects) {
                if (effectsLeft.removeIf(left -> left.getEffect() == effect.getEffect() && (left.getAmplifier() == effect.getAmplifier() || this.higherAmplifier && left.getAmplifier() > effect.getAmplifier()) && (((MobEffect)left.getEffect().value()).isInstantenous() || left.getDuration() == effect.getDuration() || this.higherDuration && left.getDuration() > effect.getDuration()))) continue;
                return false;
            }
            return effectsLeft.isEmpty() || this.extraEffects;
        }
        return false;
    }

    private static Stream<MobEffectInstance> getEffects(ItemStack stack) {
        PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return Stream.of(new MobEffectInstance[0]);
        }
        return Streams.of((Iterable)potionContents.getAllEffects());
    }

    public boolean isSimple() {
        return false;
    }
}

