/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientStack(Ingredient ingredient, int count) implements Predicate<ItemStack>
{
    public static final IngredientStack EMPTY = new IngredientStack(Ingredient.EMPTY, 0);
    public static final Codec<IngredientStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(IngredientStack::ingredient), (App)Codec.INT.fieldOf("count").forGetter(IngredientStack::count)).apply((Applicative)instance, IngredientStack::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientStack> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, IngredientStack::ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, IngredientStack::count, IngredientStack::new);

    public IngredientStack(Ingredient ingredient, int count) {
        if (count <= 0 || ingredient.isEmpty()) {
            this.ingredient = Ingredient.EMPTY;
            this.count = 0;
        } else {
            this.ingredient = ingredient;
            this.count = count;
        }
    }

    @Override
    public boolean test(ItemStack stack) {
        return stack.getCount() >= this.count && this.ingredient.test(stack);
    }

    public boolean isEmpty() {
        return this.count == 0 || this.ingredient.isEmpty();
    }
}

