/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.moddingx.libx.LibX;
import org.moddingx.libx.config.mapper.GenericValueMapper;
import org.moddingx.libx.config.mapper.MapperFactory;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ConfigValidator;
import org.moddingx.libx.event.ConfigLoadedEvent;
import org.moddingx.libx.impl.config.ConfigImpl;
import org.moddingx.libx.impl.config.ConfigState;
import org.moddingx.libx.impl.config.ModMappers;
import org.moddingx.libx.impl.network.ConfigShadowHandler;
import org.moddingx.libx.impl.network.NetworkImpl;

public class ConfigManager {
    private static final BiMap<ResourceLocation, Class<?>> configIds = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private static final Map<Class<?>, Path> configs = Collections.synchronizedMap(new HashMap());

    public static void registerValueMapper(String modid, ValueMapper<?, ?> mapper) {
        if (!Objects.equals(modid, ModLoadingContext.get().getActiveNamespace())) {
            LibX.logger.error("Wrong modid for value mapper, expected " + ModLoadingContext.get().getActiveNamespace() + " got " + modid);
        }
        ModMappers.get(modid).registerValueMapper(mapper);
    }

    public static void registerValueMapper(String modid, GenericValueMapper<?, ?, ?> mapper) {
        if (!Objects.equals(modid, ModLoadingContext.get().getActiveNamespace())) {
            LibX.logger.error("Wrong modid for generic value mapper, expected " + ModLoadingContext.get().getActiveNamespace() + " got " + modid);
        }
        ModMappers.get(modid).registerValueMapper(mapper);
    }

    public static void registerValueMapperFactory(String modid, MapperFactory<?> factory) {
        if (!Objects.equals(modid, ModLoadingContext.get().getActiveNamespace())) {
            LibX.logger.error("Wrong modid for value mapper factory, expected " + ModLoadingContext.get().getActiveNamespace() + " got " + modid);
        }
        ModMappers.get(modid).registerValueMapperFactory(factory);
    }

    public static void registerConfigValidator(String modid, ConfigValidator<?, ?> validator) {
        if (!Objects.equals(modid, ModLoadingContext.get().getActiveNamespace())) {
            LibX.logger.error("Wrong modid for config validator, expected " + ModLoadingContext.get().getActiveNamespace() + " got " + modid);
        }
        ModMappers.get(modid).registerConfigValidator(validator);
    }

    public static void registerConfig(String modid, Class<?> configClass, boolean clientConfig) {
        ConfigManager.registerConfig(ResourceLocation.fromNamespaceAndPath((String)modid, (String)"config"), configClass, clientConfig);
    }

    public static void registerConfig(ResourceLocation location, Class<?> configClass, boolean clientConfig) {
        if (configIds.containsKey((Object)location)) {
            throw new IllegalArgumentException("Config '" + String.valueOf(location) + "' is already bound to class " + String.valueOf(configClass));
        }
        if (configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + String.valueOf(configClass) + " is already registered as '" + String.valueOf(configIds.inverse().get(configClass)) + "'");
        }
        Path path = ConfigImpl.resolveConfigPath(FMLPaths.GAMEDIR.get().resolve("config"), location);
        configIds.put((Object)location, configClass);
        configs.put(configClass, path);
        new ConfigImpl(location, configClass, path, clientConfig);
        ModMappers.get(location.getNamespace()).configRegistered();
        ConfigManager.firstLoadConfig(configClass);
    }

    public static void reloadCommon() {
        for (Class<?> configClass : configs.keySet()) {
            ConfigManager.reloadConfig(configClass, true, false);
        }
    }

    public static void reloadClient() {
        if (FMLLoader.getDist() == Dist.DEDICATED_SERVER) {
            return;
        }
        for (Class<?> configClass : configs.keySet()) {
            ConfigManager.reloadConfig(configClass, false, true);
        }
    }

    private static void firstLoadConfig(Class<?> configClass) {
        if (!configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + String.valueOf(configClass) + " is not registered as a config.");
        }
        try {
            ConfigImpl config = ConfigImpl.getConfig((ResourceLocation)configIds.inverse().get(configClass));
            if (!config.clientConfig || FMLLoader.getDist() == Dist.CLIENT) {
                ConfigState defaultState = config.stateFromValues();
                config.setDefaultState(defaultState);
                ConfigState state = config.readFromFileOrCreateBy(defaultState);
                config.saveState(state);
                state.apply();
                NeoForge.EVENT_BUS.post((Event)new ConfigLoadedEvent(config.id, config.baseClass, ConfigLoadedEvent.LoadReason.INITIAL, config.clientConfig, config.path, config.path));
            }
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            LibX.logger.error("Failed to load config '" + String.valueOf(configIds.inverse().get(configClass)) + "' (class: " + String.valueOf(configClass) + ")", e);
        }
    }

    public static void reloadConfig(Class<?> configClass) {
        ConfigManager.reloadConfig(configClass, true, true);
    }

    private static void reloadConfig(Class<?> configClass, boolean allowCommon, boolean allowClient) {
        if (!allowCommon && !allowClient) {
            return;
        }
        if (!configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + String.valueOf(configClass) + " is not registered as a config.");
        }
        try {
            ConfigImpl config = ConfigImpl.getConfig((ResourceLocation)configIds.inverse().get(configClass));
            if ((config.clientConfig ? allowClient : allowCommon) && (!config.clientConfig || FMLLoader.getDist() == Dist.CLIENT)) {
                ConfigState state = config.readFromFileOrCreateByDefault();
                config.saveState(state);
                if (!config.isShadowed()) {
                    state.apply();
                }
                config.reloadClientWorldState();
                NeoForge.EVENT_BUS.post((Event)new ConfigLoadedEvent(config.id, config.baseClass, ConfigLoadedEvent.LoadReason.RELOAD, config.clientConfig, config.path, config.path));
            }
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            LibX.logger.error("Failed to reload config '" + String.valueOf(configIds.inverse().get(configClass)) + "' (class: " + String.valueOf(configClass) + ")", e);
        }
    }

    public static void synchronize(MinecraftServer server, Class<?> configClass) {
        ConfigManager.synchronize(server, null, List.of(configClass));
    }

    public static void synchronize(MinecraftServer server) {
        ConfigManager.synchronize(server, null, null);
    }

    public static void synchronize(ServerPlayer player, Class<?> configClass) {
        ConfigManager.synchronize(player.server, player, List.of(configClass));
    }

    public static void synchronize(ServerPlayer player) {
        ConfigManager.synchronize(player.server, player, null);
    }

    private static void synchronize(MinecraftServer server, @Nullable ServerPlayer receiver, @Nullable List<Class<?>> configClasses) {
        ArrayList<ConfigImpl> configs = new ArrayList<ConfigImpl>(configClasses == null ? ConfigManager.configs().size() : configClasses.size());
        if (configClasses != null) {
            for (Class<?> configClass : configClasses) {
                if (!configIds.containsValue(configClass)) {
                    throw new IllegalArgumentException("Class " + String.valueOf(configClass) + " is not registered as a config.");
                }
                ResourceLocation id = (ResourceLocation)configIds.inverse().get(configClass);
                ConfigImpl config = ConfigImpl.getConfig(id);
                if (config.clientConfig) continue;
                configs.add(config);
            }
        } else {
            for (ResourceLocation id : ConfigManager.configs()) {
                ConfigImpl config = ConfigImpl.getConfig(id);
                if (config.clientConfig) continue;
                configs.add(config);
            }
        }
        if (FMLLoader.getDist() == Dist.DEDICATED_SERVER) {
            ConfigManager.sendConfigState(server, receiver, configs);
        } else {
            LibX.logger.error("ConfigManager.synchronize was called on a physical client. Ignoring.");
        }
    }

    private static void sendConfigState(MinecraftServer server, @Nullable ServerPlayer receiver, List<ConfigImpl> configs) {
        if (configs.isEmpty()) {
            return;
        }
        List<ConfigShadowHandler.Message> messages = configs.stream().map(config -> new ConfigShadowHandler.Message((ConfigImpl)config, config.cachedOrCurrent())).toList();
        ConfigShadowHandler.Message firstMessage = messages.getFirst();
        CustomPacketPayload[] otherMessages = (ConfigShadowHandler.Message[])messages.stream().skip(1L).toArray(ConfigShadowHandler.Message[]::new);
        if (receiver != null) {
            if (NetworkImpl.getImpl().canSend(receiver, ConfigShadowHandler.TYPE)) {
                PacketDistributor.sendToPlayer((ServerPlayer)receiver, (CustomPacketPayload)firstMessage, (CustomPacketPayload[])otherMessages);
            }
        } else {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                if (!NetworkImpl.getImpl().canSend(player, ConfigShadowHandler.TYPE)) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)firstMessage, (CustomPacketPayload[])otherMessages);
            }
        }
    }

    public static Set<ResourceLocation> configs() {
        return Collections.unmodifiableSet(configIds.keySet());
    }
}

