/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Unit;
import org.moddingx.libx.LibX;

public class EnumArgumentIgnoreCase<T extends Enum<T>>
implements ArgumentType<T> {
    private final Class<T> enumClass;
    private final DynamicCommandExceptionType invalidValue;

    public static <R extends Enum<R>> EnumArgumentIgnoreCase<R> enumArgument(Class<R> enumClass) {
        return new EnumArgumentIgnoreCase<R>(enumClass);
    }

    private EnumArgumentIgnoreCase(Class<T> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Can't create enum argument for non-enum class.");
        }
        this.enumClass = enumClass;
        this.invalidValue = new DynamicCommandExceptionType(name -> Component.translatable((String)"libx.command.argument.enum.invalid", (Object[])new Object[]{enumClass.getSimpleName(), name}));
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String str = reader.readUnquotedString().toLowerCase(Locale.ROOT);
        for (Enum t : (Enum[])this.enumClass.getEnumConstants()) {
            if (!t.name().toLowerCase(Locale.ROOT).equals(str)) continue;
            return (T)t;
        }
        throw this.invalidValue.createWithContext((ImmutableStringReader)reader, (Object)str);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(str -> str.toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public static class Info
    implements ArgumentTypeInfo<EnumArgumentIgnoreCase<?>, Template> {
        public static final Info INSTANCE = new Info();

        private Info() {
        }

        public void serializeToNetwork(@Nonnull Template template, @Nonnull FriendlyByteBuf buffer) {
            buffer.writeUtf(template.enumClass.getName());
        }

        @Nonnull
        public Template deserializeFromNetwork(@Nonnull FriendlyByteBuf buffer) {
            String name = buffer.readUtf();
            try {
                Class<?> cls = Class.forName(name);
                if (cls.isEnum()) {
                    return new Template(cls);
                }
                LibX.logger.warn("Can't get enum value of type " + name + " in command argument: No enum");
                return new Template(Unit.class);
            }
            catch (ClassNotFoundException e) {
                LibX.logger.warn("Can't get enum value of type " + name + " in command argument: " + e.getMessage());
                return new Template(Unit.class);
            }
        }

        public void serializeToJson(@Nonnull Template template, @Nonnull JsonObject json) {
            json.addProperty("enum", template.enumClass.getName());
        }

        @Nonnull
        public Template unpack(@Nonnull EnumArgumentIgnoreCase<?> arg) {
            return new Template(arg.enumClass);
        }

        public class Template
        implements ArgumentTypeInfo.Template<EnumArgumentIgnoreCase<?>> {
            final Class<? extends Enum<?>> enumClass;

            private Template(Class<? extends Enum<?>> enumClass) {
                this.enumClass = enumClass;
            }

            @Nonnull
            public EnumArgumentIgnoreCase<?> instantiate(@Nonnull CommandBuildContext ctx) {
                return new EnumArgumentIgnoreCase(this.enumClass);
            }

            @Nonnull
            public ArgumentTypeInfo<EnumArgumentIgnoreCase<?>, ?> type() {
                return Info.this;
            }
        }
    }
}

