/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;

public class MoreStreamCodecs {
    public static final StreamCodec<ByteBuf, Tag> TAG = StreamCodec.of(FriendlyByteBuf::writeNbt, buf -> (Tag)Objects.requireNonNullElse(FriendlyByteBuf.readNbt((ByteBuf)buf, (NbtAccounter)NbtAccounter.create((long)0x200000L)), EndTag.INSTANCE));
    public static final StreamCodec<ByteBuf, CompoundTag> COMPOUND_TAG = StreamCodec.of(FriendlyByteBuf::writeNbt, buf -> Objects.requireNonNull(FriendlyByteBuf.readNbt((ByteBuf)buf), "Not a compound tag."));

    public static <B extends ByteBuf, T> StreamCodec<B, T> unit(final Supplier<T> value) {
        return new StreamCodec<B, T>(){

            public void encode(@Nonnull B buffer, @Nonnull T value2) {
            }

            @Nonnull
            public T decode(@Nonnull B buffer) {
                return value.get();
            }
        };
    }

    public static <B extends ByteBuf, T> StreamCodec<B, Optional<T>> maybe(final StreamCodec<? super B, T> elementCodec) {
        return new StreamCodec<B, Optional<T>>(){

            public void encode(@Nonnull B buffer, @Nonnull Optional<T> value) {
                buffer.writeBoolean(value.isPresent());
                value.ifPresent(element -> elementCodec.encode(buffer, element));
            }

            @Nonnull
            public Optional<T> decode(@Nonnull B buffer) {
                boolean present = buffer.readBoolean();
                return present ? Optional.of(elementCodec.decode(buffer)) : Optional.empty();
            }
        };
    }

    public static <B extends ByteBuf, T> StreamCodec<B, List<T>> listOf(final StreamCodec<? super B, T> elementCodec) {
        return new StreamCodec<B, List<T>>(){

            public void encode(@Nonnull B buffer, @Nonnull List<T> value) {
                VarInt.write(buffer, (int)value.size());
                for (Object element : value) {
                    elementCodec.encode(buffer, element);
                }
            }

            @Nonnull
            public List<T> decode(@Nonnull B buffer) {
                int size = VarInt.read(buffer);
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    list.add(elementCodec.decode(buffer));
                }
                return Collections.unmodifiableList(list);
            }
        };
    }

    public static <B extends ByteBuf, K, V> StreamCodec<B, Map<K, V>> mapOf(final StreamCodec<? super B, K> keyCodec, final StreamCodec<? super B, V> valueCodec) {
        return new StreamCodec<B, Map<K, V>>(){

            public void encode(@Nonnull B buffer, @Nonnull Map<K, V> value) {
                VarInt.write(buffer, (int)value.size());
                for (Map.Entry entry : value.entrySet()) {
                    keyCodec.encode(buffer, entry.getKey());
                    valueCodec.encode(buffer, entry.getValue());
                }
            }

            @Nonnull
            public Map<K, V> decode(@Nonnull B buffer) {
                int size = VarInt.read(buffer);
                HashMap<Object, Object> map = new HashMap<Object, Object>(size);
                for (int i = 0; i < size; ++i) {
                    Object key = keyCodec.decode(buffer);
                    Object value = valueCodec.decode(buffer);
                    map.put(key, value);
                }
                return Collections.unmodifiableMap(map);
            }
        };
    }
}

