/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.codec;

import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.Unit;
import org.moddingx.libx.codec.TypedEncoder;
import org.moddingx.libx.impl.codec.EnumCodec;
import org.moddingx.libx.impl.codec.ErrorCodec;
import org.moddingx.libx.impl.codec.FixedCodec;
import org.moddingx.libx.impl.codec.LazyCodec;
import org.moddingx.libx.impl.codec.MapDispatchedCodec;
import org.moddingx.libx.impl.codec.OptionCodec;
import org.moddingx.libx.impl.codec.TrueOptionalMapCodec;
import org.moddingx.libx.impl.codec.TypeMappedCodec;

public class MoreCodecs {
    public static final Codec<Unit> UNIT = new Codec<Unit>(){

        public <T> DataResult<T> encode(Unit input, DynamicOps<T> ops, T prefix) {
            return DataResult.success(prefix);
        }

        public <T> DataResult<Pair<Unit, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)Pair.of((Object)Unit.INSTANCE, input));
        }
    };

    public static <T> Codec<T> error(String msg) {
        return MoreCodecs.error(msg, msg);
    }

    public static <T> Codec<T> error(String encodeMsg, String decodeMsg) {
        return new ErrorCodec(encodeMsg, decodeMsg);
    }

    public static <T> Codec<Optional<T>> option(Codec<T> codec) {
        return new OptionCodec<T>(codec);
    }

    public static Codec<Unit> fixed(Number value) {
        return MoreCodecs.fixed(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(value)));
    }

    public static Codec<Unit> fixed(String value) {
        return MoreCodecs.fixed(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(value)));
    }

    public static Codec<Unit> fixed(Dynamic<?> value) {
        return new FixedCodec(value);
    }

    public static <T extends Enum<T>> Codec<T> enumCodec(Class<T> clazz) {
        return EnumCodec.get(clazz);
    }

    public static <M, E> Codec<Pair<M, E>> extend(Codec<M> codec, MapCodec<E> extension) {
        return MoreCodecs.extend(codec, extension, Function.identity(), Pair::of);
    }

    public static <A, M, E> Codec<A> extend(Codec<M> codec, MapCodec<E> extension, Function<A, Pair<M, E>> decompose, BiFunction<M, E, A> construct) {
        return MoreCodecs.mapDispatch(extension, key -> DataResult.success((Object)codec), decompose.andThen(Pair::swap), (e, m) -> DataResult.success(construct.apply(m, e)));
    }

    public static <A, K, V> Codec<A> mapDispatch(MapCodec<K> keyCodec, Function<K, DataResult<Codec<? extends V>>> valueCodecs, Function<A, Pair<K, V>> decompose, BiFunction<K, V, DataResult<A>> construct) {
        return new MapDispatchedCodec<A, K, V>(keyCodec, valueCodecs, decompose, construct);
    }

    public static <T> Codec<T> lazy(Supplier<Codec<T>> codec) {
        return new LazyCodec(codec);
    }

    public static <T> MapCodec<Optional<T>> optionalFieldOf(Codec<T> codec, String name) {
        return new TrueOptionalMapCodec<T>(codec, name);
    }

    public static <T> MapCodec<T> optionalFieldOf(Codec<T> codec, String name, T defaultValue) {
        return MoreCodecs.optionalFieldOf(codec, name).xmap(value -> value.orElse(defaultValue), value -> Objects.equals(value, defaultValue) ? Optional.empty() : Optional.of(value));
    }

    @SafeVarargs
    public static <T> Codec<T> typeMapped(TypedEncoder<T, ?> ... encoders) {
        if (encoders.length == 0) {
            return MoreCodecs.error("Empty type mapped codec");
        }
        ArrayList list = new ArrayList();
        for (TypedEncoder<T, ?> encoder : encoders) {
            list.add(encoder);
        }
        return new TypeMappedCodec(list, null);
    }

    @SafeVarargs
    public static <T> Codec<T> typeMapped(Codec<T> fallback, TypedEncoder<T, ?> ... encoders) {
        if (encoders.length == 0) {
            return fallback;
        }
        ArrayList list = new ArrayList();
        for (TypedEncoder<T, ?> encoder : encoders) {
            list.add(encoder);
        }
        return new TypeMappedCodec(list, fallback);
    }
}

