/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.block;

import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.moddingx.libx.block.RotationShape;

public class DirectionShape
extends RotationShape {
    protected final VoxelShape up;
    protected final VoxelShape down;

    public DirectionShape(VoxelShape baseShape) {
        super(DirectionShape.rotatedV(baseShape));
        this.up = baseShape;
        this.down = DirectionShape.rotatedV(this.north);
    }

    @Override
    public VoxelShape getShape(Direction direction) {
        return switch (direction) {
            case Direction.UP -> this.up;
            case Direction.DOWN -> this.down;
            default -> super.getShape(direction);
        };
    }

    private static VoxelShape rotatedV(VoxelShape src) {
        ArrayList boxes = new ArrayList();
        src.forAllBoxes((fromX, fromY, fromZ, toX, toY, toZ) -> boxes.add(Shapes.box((double)Math.min(fromX, toX), (double)Math.min(fromZ, toZ), (double)Math.min(1.0 - fromY, 1.0 - toY), (double)Math.max(fromX, toX), (double)Math.max(fromZ, toZ), (double)Math.max(1.0 - fromY, 1.0 - toY))));
        return Shapes.or((VoxelShape)Shapes.empty(), (VoxelShape[])boxes.toArray(new VoxelShape[0])).optimize();
    }
}

