/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base.decoration;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.moddingx.libx.base.BlockBase;
import org.moddingx.libx.base.decoration.DecorationContext;
import org.moddingx.libx.base.decoration.DecorationMaterial;
import org.moddingx.libx.base.decoration.DecorationType;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;
import org.moddingx.libx.registration.SetupContext;

public class DecoratedBlock
extends BlockBase {
    private final DecorationContext context;
    @Nullable
    private DecorationMaterial.MaterialProperties materialProperties;
    @Nullable
    private DecorationContext.RegistrationInfo info;

    public DecoratedBlock(ModX mod, DecorationContext context, BlockBehaviour.Properties materialProperties) {
        this(mod, context, materialProperties, new Item.Properties());
    }

    public DecoratedBlock(ModX mod, DecorationContext context, BlockBehaviour.Properties materialProperties, Item.Properties itemProperties) {
        super(mod, materialProperties, itemProperties);
        this.context = context;
        this.info = null;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        this.init(ctx);
        super.registerAdditional(ctx, builder);
        for (Map.Entry<String, Registerable> entry : Objects.requireNonNull(this.info).registerMap().entrySet()) {
            builder.registerNamed(null, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setupCommon(SetupContext ctx) {
        this.init(ctx);
        ctx.enqueue(this.materialProperties::register);
    }

    private void init(RegistrationContext ctx) {
        if (this.materialProperties == null) {
            this.materialProperties = this.context.material().init(ctx.id());
        }
        if (this.info == null) {
            this.info = this.context.register(this.mod, this);
        }
    }

    public DecorationContext getContext() {
        return this.context;
    }

    public DecorationMaterial.MaterialProperties getMaterialProperties() {
        if (this.materialProperties == null) {
            throw new IllegalStateException("Decorated block not initialised.");
        }
        return this.materialProperties;
    }

    public boolean has(DecorationType<?> type) {
        if (this.info == null) {
            throw new IllegalStateException("Decorated block not initialised.");
        }
        return this.context.has(type) && this.info.elementMap().containsKey(type);
    }

    @Nonnull
    public <T> T get(DecorationType<T> type) {
        if (this.info == null) {
            throw new IllegalStateException("Decorated block not initialised.");
        }
        if (type == DecorationType.BASE) {
            return (T)this;
        }
        if (this.has(type)) {
            return (T)this.info.elementMap().get(type).element();
        }
        throw new NoSuchElementException("Decoration context " + String.valueOf(this.context) + " has no element of type " + type.name() + ": " + String.valueOf(type));
    }

    public int getLightBlock(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return super.getLightBlock(state, level, pos);
    }
}

