/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.moddingx.libx.base.BlockBase;
import org.moddingx.libx.menu.BlockMenu;
import org.moddingx.libx.menu.type.AdvancedMenuType;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public class MenuBlock<C extends BlockMenu>
extends BlockBase {
    public final AdvancedMenuType<C, ? super BlockPos> menu;

    public MenuBlock(ModX mod, AdvancedMenuType<C, ? super BlockPos> menu, BlockBehaviour.Properties properties) {
        this(mod, menu, properties, new Item.Properties());
    }

    public MenuBlock(ModX mod, AdvancedMenuType<C, ? super BlockPos> menu, BlockBehaviour.Properties properties, @Nullable Item.Properties itemProperties) {
        super(mod, properties, itemProperties);
        this.menu = menu;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        super.registerAdditional(ctx, builder);
        builder.register(Registries.MENU, this.menu);
    }

    @Nonnull
    public InteractionResult useWithoutItem(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult hit) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent title = Component.translatable((String)("screen." + this.mod.modid + "." + Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)this)).getPath()));
            this.menu.open(serverPlayer, (Component)title, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }
}

