/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.moddingx.libx.annotation.registration.PlainRegisterable;
import org.moddingx.libx.impl.base.fluid.DefaultBucketItem;
import org.moddingx.libx.impl.base.fluid.DefaultClientExtensions;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;
import org.moddingx.libx.registration.util.ClientExtensionInfo;

@PlainRegisterable
public class FluidBase
implements ItemLike,
Registerable {
    protected final ModX mod;
    private final FluidType fluidType;
    private final FlowingFluid sourceFluid;
    private final FlowingFluid flowingFluid;
    private final LiquidBlock liquidBlock;
    private final BucketItem bucketItem;

    public FluidBase(ModX mod, Builder fluidBuilder) {
        this.mod = mod;
        BaseFlowingFluid.Properties fluidProperties = (BaseFlowingFluid.Properties)fluidBuilder.fluidProperties.apply(new BaseFlowingFluid.Properties(this::getFluidType, this::getSourceFluid, this::getFlowingFluid));
        fluidProperties = fluidProperties.block(this::getLiquidBlock).bucket(this::getBucketItem);
        this.fluidType = fluidBuilder.fluidTypeFactory.apply((FluidType.Properties)fluidBuilder.fluidTypeProperties);
        this.sourceFluid = fluidBuilder.sourceFluidFactory.apply((BaseFlowingFluid.Properties)fluidProperties);
        this.flowingFluid = fluidBuilder.flowingFluidFactory.apply((BaseFlowingFluid.Properties)fluidProperties);
        this.liquidBlock = fluidBuilder.liquidBlockFactory.apply((FlowingFluid)this.sourceFluid, (BlockBehaviour.Properties)fluidBuilder.blockProperties);
        this.bucketItem = fluidBuilder.bucketItemFactory.apply((Fluid)this.sourceFluid, (Item.Properties)fluidBuilder.bucketItemProperties);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected ClientExtensionInfo.Fluid createClientExtensions(ResourceLocation id) {
        ResourceLocation stillTexture = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("block/" + id.getPath()));
        ResourceLocation flowingTexture = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("block/" + id.getPath() + "_flowing"));
        return new ClientExtensionInfo.Fluid(new DefaultClientExtensions(stillTexture, flowingTexture));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        builder.register(NeoForgeRegistries.Keys.FLUID_TYPES, this.fluidType);
        builder.register(Registries.FLUID, this.sourceFluid);
        builder.registerNamed(Registries.FLUID, "flowing", this.flowingFluid);
        builder.register(Registries.BLOCK, this.liquidBlock);
        builder.registerNamed(Registries.ITEM, "bucket", this.bucketItem);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @OverridingMethodsMustInvokeSuper
    public void registerClientAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        builder.register(null, this.createClientExtensions(ctx.id()));
    }

    @Nonnull
    public final FluidType getFluidType() {
        return this.fluidType;
    }

    @Nonnull
    public final Fluid getFluid() {
        return this.getSourceFluid();
    }

    @Nonnull
    public final Fluid getSourceFluid() {
        return this.sourceFluid;
    }

    @Nonnull
    public final Fluid getFlowingFluid() {
        return this.flowingFluid;
    }

    @Nonnull
    public final LiquidBlock getLiquidBlock() {
        return this.liquidBlock;
    }

    @Nonnull
    public final BucketItem getBucketItem() {
        return this.bucketItem;
    }

    @Nonnull
    public final Item asItem() {
        return this.getBucketItem();
    }

    public static Builder fluidBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Function<? super FluidType.Properties, ? extends FluidType> fluidTypeFactory = FluidType::new;
        private Function<? super BaseFlowingFluid.Properties, ? extends FlowingFluid> sourceFluidFactory = BaseFlowingFluid.Source::new;
        private Function<? super BaseFlowingFluid.Properties, ? extends FlowingFluid> flowingFluidFactory = BaseFlowingFluid.Flowing::new;
        private BiFunction<? super FlowingFluid, ? super BlockBehaviour.Properties, ? extends LiquidBlock> liquidBlockFactory = LiquidBlock::new;
        private BiFunction<? super Fluid, ? super Item.Properties, ? extends BucketItem> bucketItemFactory = DefaultBucketItem::new;
        private FluidType.Properties fluidTypeProperties = FluidType.Properties.create();
        private BlockBehaviour.Properties blockProperties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER);
        private Item.Properties bucketItemProperties = new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1);
        private UnaryOperator<BaseFlowingFluid.Properties> fluidProperties = UnaryOperator.identity();

        private Builder() {
        }

        public Builder fluidType(Function<? super FluidType.Properties, ? extends FluidType> fluidTypeFactory) {
            this.fluidTypeFactory = fluidTypeFactory;
            return this;
        }

        public Builder sourceFluid(Function<? super BaseFlowingFluid.Properties, ? extends FlowingFluid> sourceFluidFactory) {
            this.sourceFluidFactory = sourceFluidFactory;
            return this;
        }

        public Builder flowingFluid(Function<? super BaseFlowingFluid.Properties, ? extends FlowingFluid> flowingFluidFactory) {
            this.flowingFluidFactory = flowingFluidFactory;
            return this;
        }

        public Builder liquidBlock(BiFunction<? super FlowingFluid, ? super BlockBehaviour.Properties, ? extends LiquidBlock> liquidBlockFactory) {
            this.liquidBlockFactory = liquidBlockFactory;
            return this;
        }

        public Builder bucketItem(BiFunction<? super Fluid, ? super Item.Properties, ? extends BucketItem> bucketItemFactory) {
            this.bucketItemFactory = bucketItemFactory;
            return this;
        }

        public Builder properties(FluidType.Properties fluidTypeProperties) {
            this.fluidTypeProperties = fluidTypeProperties;
            return this;
        }

        public Builder properties(UnaryOperator<FluidType.Properties> fluidTypePropertiesOp) {
            this.fluidTypeProperties = (FluidType.Properties)fluidTypePropertiesOp.apply(this.fluidTypeProperties);
            return this;
        }

        public Builder blockProperties(BlockBehaviour.Properties blockProperties) {
            this.blockProperties = blockProperties;
            return this;
        }

        public Builder blockProperties(UnaryOperator<BlockBehaviour.Properties> blockPropertiesOp) {
            this.blockProperties = (BlockBehaviour.Properties)blockPropertiesOp.apply(this.blockProperties);
            return this;
        }

        public Builder bucketItemProperties(Item.Properties bucketItemProperties) {
            this.bucketItemProperties = bucketItemProperties;
            return this;
        }

        public Builder bucketItemProperties(UnaryOperator<Item.Properties> bucketItemPropertiesOp) {
            this.bucketItemProperties = (Item.Properties)bucketItemPropertiesOp.apply(this.bucketItemProperties);
            return this;
        }

        public Builder fluidProperties(UnaryOperator<BaseFlowingFluid.Properties> fluidPropertiesOp) {
            this.fluidProperties = Builder.compose(this.fluidProperties, fluidPropertiesOp);
            return this;
        }

        private static <T> UnaryOperator<T> compose(UnaryOperator<T> a, UnaryOperator<T> b) {
            return t -> b.apply(a.apply(t));
        }
    }
}

