/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor.modinit;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.moddingx.libx.annotation.processor.Classes;
import org.moddingx.libx.annotation.processor.modinit.codec.GeneratedCodec;
import org.moddingx.libx.annotation.processor.modinit.config.RegisteredConfig;
import org.moddingx.libx.annotation.processor.modinit.config.RegisteredMapper;
import org.moddingx.libx.annotation.processor.modinit.model.LoadableModel;
import org.moddingx.libx.annotation.processor.modinit.register.RegistrationEntry;

public class ModInit {
    public static final List<String> DEFAULT_PARAM_CODEC_FIELDS = List.of("CODEC", "DIRECT_CODEC");
    public final String modid;
    public final Element modClass;
    private final Map<Integer, List<RegistrationEntry>> registration = new HashMap<Integer, List<RegistrationEntry>>();
    private final List<LoadableModel> models = new ArrayList<LoadableModel>();
    private final List<RegisteredMapper> configMappers = new ArrayList<RegisteredMapper>();
    private final List<RegisteredConfig> configs = new ArrayList<RegisteredConfig>();
    private final List<GeneratedCodec> codecs = new ArrayList<GeneratedCodec>();

    public ModInit(String modid, Element modClass, Messager messager) {
        this.modid = modid;
        this.modClass = modClass;
        if (modClass.getEnclosingElement().getKind() != ElementKind.PACKAGE || !(modClass.getEnclosingElement() instanceof PackageElement)) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Parent element of mod class is not a package", modClass);
        }
    }

    public void addRegistration(int priority, List<RegistrationEntry> entries) {
        if (!this.registration.containsKey(priority)) {
            this.registration.put(priority, new ArrayList());
        }
        List<RegistrationEntry> list = this.registration.get(priority);
        list.addAll(entries);
    }

    public void addModel(String classFqn, String fieldName, String modelNamespace, String modelPath) {
        this.models.add(new LoadableModel(classFqn, fieldName, modelNamespace.isEmpty() ? this.modid : modelNamespace, modelPath));
    }

    public void addConfigMapper(String classFqn, String targetTypeSource, @Nullable String requiresMod, boolean genericType) {
        this.configMappers.add(new RegisteredMapper(classFqn, targetTypeSource, requiresMod, genericType));
    }

    public void addConfig(String name, boolean client, @Nullable String requiresMod, String classFqn) {
        this.configs.add(new RegisteredConfig(name, client, requiresMod, classFqn));
    }

    public void addCodec(GeneratedCodec codec) {
        this.codecs.add(codec);
    }

    public void write(Filer filer, Messager messager) {
        try {
            List allReg = this.registration.entrySet().stream().sorted(Comparator.comparingInt(e -> -((Integer)e.getKey()).intValue())).flatMap(e -> ((List)e.getValue()).stream()).toList();
            JavaFileObject file = filer.createSourceFile(String.valueOf(((PackageElement)this.modClass.getEnclosingElement()).getQualifiedName()) + "." + String.valueOf(this.modClass.getSimpleName()) + "$", this.modClass);
            Writer writer = file.openWriter();
            writer.write("package " + String.valueOf(((PackageElement)this.modClass.getEnclosingElement()).getQualifiedName()) + ";");
            writer.write("@" + SuppressWarnings.class.getCanonicalName() + "({\"all\",\"unchecked\",\"rawtypes\",\"deprecation\"})");
            writer.write("public class " + String.valueOf(this.modClass.getSimpleName()) + "${");
            writer.write("private static " + Classes.sourceName("org.moddingx.libx.mod.ModX") + " mod=null;");
            if (!this.codecs.isEmpty()) {
                writer.write("public static final " + Map.class.getCanonicalName() + "<Class<?>," + Classes.sourceName("com.mojang.serialization.Codec") + "<?>>codecs=buildCodecs();");
                writer.write("private static final " + Map.class.getCanonicalName() + "<Class<?>," + Classes.sourceName("com.mojang.serialization.Codec") + "<?>>buildCodecs(){");
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.LazyMapBuilder") + " builder=" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".lazyMapBuilder();");
                for (GeneratedCodec codec : this.codecs) {
                    GeneratedCodec.CodecElement param;
                    int i;
                    writer.write("builder.put(" + codec.fqn() + ".class,");
                    writer.write("() -> " + Classes.sourceName("com.mojang.serialization.codecs.RecordCodecBuilder") + ".<" + codec.fqn() + ">create(instance->");
                    writer.write("instance.group(");
                    for (i = 0; i < codec.params().size(); ++i) {
                        param = codec.params().get(i);
                        writer.write("(");
                        param.writeCode(writer);
                        writer.write(")");
                        if (i >= codec.params().size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(").apply(instance,instance.stable(");
                    writer.write("(");
                    for (i = 0; i < codec.params().size(); ++i) {
                        param = codec.params().get(i);
                        writer.write(param.typeFqnBoxed + " ctorArg" + i);
                        if (i >= codec.params().size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(")->{");
                    writer.write("return new " + codec.fqn() + "(");
                    for (i = 0; i < codec.params().size(); ++i) {
                        writer.write("ctorArg" + i);
                        if (i >= codec.params().size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(");");
                    writer.write("}");
                    writer.write("))");
                    writer.write("));");
                }
                writer.write("return builder.build();");
                writer.write("}");
            }
            writer.write("public static void init(" + Classes.sourceName("org.moddingx.libx.mod.ModX") + " mod){");
            writer.write(String.valueOf(this.modClass.getSimpleName()) + "$.mod=mod;");
            for (RegisteredMapper mapper : this.configMappers) {
                if (mapper.requiresMod() != null) {
                    writer.write("if(" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".isModLoaded(" + ModInit.quote(mapper.requiresMod()) + ")){");
                }
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".registerConfigMapper(mod,(" + mapper.targetTypeSource() + ")new " + mapper.classFqn() + (mapper.genericType() ? "<>" : "") + "());");
                if (mapper.requiresMod() == null) continue;
                writer.write("}");
            }
            for (RegisteredConfig config : this.configs) {
                if (config.requiresMod() != null) {
                    writer.write("if(" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".isModLoaded(" + ModInit.quote(config.requiresMod()) + ")){");
                }
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".registerConfig(mod," + ModInit.quote(config.name()) + "," + config.classFqn() + ".class," + config.client() + ");");
                if (config.requiresMod() == null) continue;
                writer.write("}");
            }
            if (!allReg.isEmpty()) {
                writer.write("((" + Classes.sourceName("org.moddingx.libx.mod.ModXRegistration") + ")mod).addRegistrationHandler(" + String.valueOf(this.modClass.getSimpleName()) + "$::register);");
            }
            if (!this.models.isEmpty()) {
                writer.write("if(" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".isDistClient()){registerClientOnlyEventListeners();}");
            }
            writer.write("}");
            if (!allReg.isEmpty()) {
                writer.write("private static void register(){");
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".runUnchecked(()->{");
                for (RegistrationEntry entry : allReg) {
                    writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".register(mod," + (entry.registryFqn() == null ? "null" : entry.registryFqn()) + "," + ModInit.quote(entry.name()) + "," + entry.fieldClassFqn() + "." + entry.fieldName() + ");");
                }
                writer.write("});");
                writer.write("}");
            }
            if (!this.models.isEmpty()) {
                writer.write("private static void registerClientOnlyEventListeners(){");
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".addModListener(mod," + Classes.sourceName("net.neoforged.neoforge.client.event.ModelEvent$RegisterAdditional") + ".class," + String.valueOf(this.modClass.getSimpleName()) + "$::registerModels);");
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".addLowModListener(mod," + Classes.sourceName("net.neoforged.neoforge.client.event.ModelEvent$BakingCompleted") + ".class," + String.valueOf(this.modClass.getSimpleName()) + "$::bakeModels);");
                writer.write("}");
                writer.write("@" + Classes.sourceName("net.neoforged.api.distmarker.OnlyIn") + "(" + Classes.sourceName("net.neoforged.api.distmarker.Dist") + ".CLIENT)");
                writer.write("private static void registerModels(" + Classes.sourceName("net.neoforged.neoforge.client.event.ModelEvent$RegisterAdditional") + " event){");
                for (LoadableModel model : this.models) {
                    writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".addSpecialModel(event," + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".newRL(" + ModInit.quote(model.modelNamespace()) + "," + ModInit.quote(model.modelPath()) + "));");
                }
                writer.write("}");
                writer.write("@" + Classes.sourceName("net.neoforged.api.distmarker.OnlyIn") + "(" + Classes.sourceName("net.neoforged.api.distmarker.Dist") + ".CLIENT)");
                writer.write("private static void bakeModels(" + Classes.sourceName("net.neoforged.neoforge.client.event.ModelEvent$BakingCompleted") + " event){");
                for (LoadableModel model : this.models) {
                    writer.write(model.classFqn() + "." + model.fieldName() + "=" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".getSpecialModel(event," + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".newRL(" + ModInit.quote(model.modelNamespace()) + "," + ModInit.quote(model.modelPath()) + "));");
                }
                writer.write("}");
            }
            writer.write("}\n");
            writer.close();
        }
        catch (IOException e2) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Failed to generate source code: " + String.valueOf(e2), this.modClass);
        }
    }

    public static String quote(String str) {
        StringBuilder sb = new StringBuilder("\"");
        for (char chr : str.toCharArray()) {
            if (chr == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (chr == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (chr == '\'') {
                sb.append("\\'");
                continue;
            }
            if (chr == '\n') {
                sb.append("\\n");
                continue;
            }
            if (chr == '\r') {
                sb.append("\\r");
                continue;
            }
            if (chr == '\t') {
                sb.append("\\t");
                continue;
            }
            if (chr == '\b') {
                sb.append("\\b");
                continue;
            }
            if (chr <= '\u001f' || chr > '\u00ff') {
                sb.append(String.format("\\u%04d", chr));
                continue;
            }
            sb.append(chr);
        }
        sb.append("\"");
        return sb.toString();
    }
}

