/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor.misc;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.moddingx.libx.annotation.processor.Classes;
import org.moddingx.libx.annotation.processor.Processor;

public class NullityProcessor
extends Processor {
    @Override
    public Class<?>[] getTypes() {
        return new Class[0];
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        set.add(Classes.sourceName("org.jetbrains.annotations.NotNull"));
        set.add(Classes.sourceName("org.jetbrains.annotations.Nullable"));
        return set;
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        set.add("mod.properties.javax_nullity");
        return set;
    }

    @Override
    public void run(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.options().containsKey("mod.properties.javax_nullity") || !Boolean.parseBoolean(this.options().get("mod.properties.javax_nullity"))) {
            return;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(this.typeElement("org.jetbrains.annotations.NotNull"))) {
            this.messager().printMessage(Diagnostic.Kind.ERROR, "This should use javax.annotation.Nonnull.", element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(this.typeElement("org.jetbrains.annotations.Nullable"))) {
            this.messager().printMessage(Diagnostic.Kind.ERROR, "This should use javax.annotation.Nullable.", element);
        }
    }
}

