/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor;

import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.moddingx.libx.annotation.processor.Classes;
import org.moddingx.libx.annotation.processor.ProcessorEnv;

public abstract class Processor
extends AbstractProcessor
implements ProcessorEnv {
    private Types types;
    private Elements elements;
    private Trees trees;
    private Filer filer;
    private Messager messager;
    private Map<String, String> options;
    private Set<String> supported = null;
    private RoundEnvironment roundEnv = null;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.trees = Trees.instance(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.options = Map.copyOf(processingEnv.getOptions());
    }

    public abstract Class<?>[] getTypes();

    @Override
    public Types types() {
        return Objects.requireNonNull(this.types);
    }

    @Override
    public Elements elements() {
        return Objects.requireNonNull(this.elements);
    }

    @Override
    public Trees trees() {
        return Objects.requireNonNull(this.trees);
    }

    @Override
    public Filer filer() {
        return Objects.requireNonNull(this.filer);
    }

    @Override
    public Messager messager() {
        return Objects.requireNonNull(this.messager);
    }

    @Override
    public Map<String, String> options() {
        return Objects.requireNonNull(this.options);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (this.supported == null) {
            HashSet<String> s = new HashSet<String>();
            for (Class<?> clazz : this.getTypes()) {
                s.add(clazz.getCanonicalName());
            }
            this.supported = s;
        }
        return this.supported;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return TARGET;
    }

    @Override
    public TypeMirror forClass(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.types.getArrayType(this.forClass(clazz.getComponentType()));
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return this.types.getNoType(TypeKind.VOID);
            }
            if (clazz == Boolean.TYPE) {
                return this.types.getPrimitiveType(TypeKind.BOOLEAN);
            }
            if (clazz == Byte.TYPE) {
                return this.types.getPrimitiveType(TypeKind.BYTE);
            }
            if (clazz == Character.TYPE) {
                return this.types.getPrimitiveType(TypeKind.CHAR);
            }
            if (clazz == Short.TYPE) {
                return this.types.getPrimitiveType(TypeKind.SHORT);
            }
            if (clazz == Integer.TYPE) {
                return this.types.getPrimitiveType(TypeKind.INT);
            }
            if (clazz == Long.TYPE) {
                return this.types.getPrimitiveType(TypeKind.LONG);
            }
            if (clazz == Float.TYPE) {
                return this.types.getPrimitiveType(TypeKind.FLOAT);
            }
            if (clazz == Double.TYPE) {
                return this.types.getPrimitiveType(TypeKind.DOUBLE);
            }
            throw new IllegalArgumentException("Failed to resolve class to a type: " + String.valueOf(clazz));
        }
        return this.typeElement(clazz).asType();
    }

    @Override
    public TypeMirror forClass(String binaryName) {
        if (binaryName.startsWith("[")) {
            return this.forDescriptor(binaryName);
        }
        return this.typeElement(binaryName).asType();
    }

    private TypeMirror forDescriptor(String descriptor) {
        if (descriptor.startsWith("[")) {
            return this.types.getArrayType(this.forDescriptor(descriptor.substring(1)));
        }
        if (descriptor.equals("V")) {
            return this.types.getNoType(TypeKind.VOID);
        }
        if (descriptor.equals("Z")) {
            return this.types.getPrimitiveType(TypeKind.BOOLEAN);
        }
        if (descriptor.equals("B")) {
            return this.types.getPrimitiveType(TypeKind.BYTE);
        }
        if (descriptor.equals("C")) {
            return this.types.getPrimitiveType(TypeKind.CHAR);
        }
        if (descriptor.equals("S")) {
            return this.types.getPrimitiveType(TypeKind.SHORT);
        }
        if (descriptor.equals("I")) {
            return this.types.getPrimitiveType(TypeKind.INT);
        }
        if (descriptor.equals("J")) {
            return this.types.getPrimitiveType(TypeKind.LONG);
        }
        if (descriptor.equals("F")) {
            return this.types.getPrimitiveType(TypeKind.FLOAT);
        }
        if (descriptor.equals("D")) {
            return this.types.getPrimitiveType(TypeKind.DOUBLE);
        }
        if (descriptor.startsWith("L") && descriptor.endsWith(";")) {
            return this.forClass(descriptor.substring(1, descriptor.length() - 1));
        }
        throw new IllegalArgumentException("Invalid type descriptor: " + descriptor);
    }

    @Override
    public TypeElement typeElement(TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType) {
            DeclaredType declared = (DeclaredType)type;
            Element elem = declared.asElement();
            if ((elem.getKind().isClass() || elem.getKind().isInterface()) && elem instanceof TypeElement) {
                TypeElement typeElem = (TypeElement)elem;
                return typeElem;
            }
            throw new IllegalArgumentException("Failed to resolve type " + String.valueOf(type) + ": " + String.valueOf(elem) + " is not at type");
        }
        throw new IllegalArgumentException("Failed to resolve type " + String.valueOf(type) + ": Not a class");
    }

    @Override
    public TypeElement typeElement(Class<?> clazz) {
        TypeElement elem = this.elements.getTypeElement(clazz.getCanonicalName());
        if (elem == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " not found. (Source name: " + clazz.getCanonicalName() + ")");
        }
        return elem;
    }

    @Override
    public TypeElement typeElement(String binaryName) {
        TypeElement elem = this.elements.getTypeElement(Classes.sourceName(binaryName));
        if (elem == null) {
            throw new IllegalArgumentException("Type " + binaryName + " not found. (Source name: " + Classes.sourceName(binaryName) + ")");
        }
        return elem;
    }

    @Override
    public boolean isSuppressed(Element element, String warnings) {
        SuppressWarnings sw = element.getAnnotation(SuppressWarnings.class);
        if (sw != null) {
            return Arrays.asList(sw.value()).contains(warnings);
        }
        return false;
    }

    @Override
    public <T extends Element> Optional<T> contained(Element element, Class<T> clazz) {
        return this.contained(element, clazz, elem -> true);
    }

    @Override
    public <T extends Element> Optional<T> contained(Element element, Class<T> clazz, Predicate<T> filter) {
        return element.getEnclosedElements().stream().filter(e -> clazz.isAssignableFrom(e.getClass())).filter(e -> filter.test(e)).findFirst();
    }

    @Override
    public boolean sameErasure(TypeMirror type1, TypeMirror type2) {
        return this.types.isSameType(this.types.erasure(type1), this.types.erasure(type2));
    }

    @Override
    public boolean subTypeErasure(TypeMirror child, TypeMirror parent) {
        try {
            return this.types.isSubtype(this.types.erasure(child), this.types.erasure(parent));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public TypeMirror classType(Supplier<Class<?>> accessor) {
        try {
            return this.forClass(accessor.get());
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
    }

    @Override
    public List<? extends TypeMirror> classTypes(Supplier<List<Class<?>>> accessor) {
        try {
            return accessor.get().stream().map(this::forClass).collect(Collectors.toList());
        }
        catch (MirroredTypesException e) {
            return e.getTypeMirrors();
        }
    }

    @Override
    public TypeMirror boxed(TypeMirror type) {
        if (type.getKind() == TypeKind.VOID) {
            return this.forClass(Void.class);
        }
        if (type.getKind() == TypeKind.BOOLEAN) {
            return this.forClass(Boolean.class);
        }
        if (type.getKind() == TypeKind.BYTE) {
            return this.forClass(Byte.class);
        }
        if (type.getKind() == TypeKind.CHAR) {
            return this.forClass(Character.class);
        }
        if (type.getKind() == TypeKind.SHORT) {
            return this.forClass(Short.class);
        }
        if (type.getKind() == TypeKind.INT) {
            return this.forClass(Integer.class);
        }
        if (type.getKind() == TypeKind.LONG) {
            return this.forClass(Long.class);
        }
        if (type.getKind() == TypeKind.FLOAT) {
            return this.forClass(Float.class);
        }
        if (type.getKind() == TypeKind.DOUBLE) {
            return this.forClass(Double.class);
        }
        return type;
    }

    @Override
    public TypeMirror unboxed(TypeMirror type) {
        if (this.sameErasure(type, this.forClass(Void.class))) {
            return this.forClass(Void.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Boolean.class))) {
            return this.forClass(Boolean.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Byte.class))) {
            return this.forClass(Byte.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Character.class))) {
            return this.forClass(Character.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Short.class))) {
            return this.forClass(Short.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Integer.class))) {
            return this.forClass(Integer.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Long.class))) {
            return this.forClass(Long.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Float.class))) {
            return this.forClass(Float.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Double.class))) {
            return this.forClass(Double.TYPE);
        }
        return type;
    }

    @Override
    public List<TypeElement> getAllProcessedTypes() {
        if (this.roundEnv == null) {
            throw new IllegalStateException("round environment not initialised. This is an error in the AP " + String.valueOf(this.getClass()));
        }
        ArrayList<TypeElement> allTypes = new ArrayList<TypeElement>();
        for (Element element : this.roundEnv.getRootElements()) {
            this.addAllToList(element, allTypes);
        }
        return List.copyOf(allTypes);
    }

    private void addAllToList(Element element, List<TypeElement> allTypes) {
        if ((element.getKind().isClass() || element.getKind().isInterface()) && element instanceof TypeElement) {
            TypeElement type = (TypeElement)element;
            allTypes.add(type);
            type.getEnclosedElements().forEach(e -> this.addAllToList((Element)e, allTypes));
        }
    }

    @Override
    public <T> Map<String, Set<T>> getPossibleOverrideMap(TypeElement element, Function<ExecutableElement, Optional<T>> factory) {
        HashMap possibleOverrides = new HashMap();
        List parents = this.types().directSupertypes(element.asType()).stream().flatMap(t -> {
            Stream<Object> stream;
            if (t.getKind() == TypeKind.DECLARED && t instanceof DeclaredType) {
                DeclaredType declared = (DeclaredType)t;
                stream = Stream.of(declared.asElement());
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).filter(e -> e.getKind().isClass() || e.getKind().isInterface()).flatMap(e -> {
            Stream<Object> stream;
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                stream = Stream.of(te);
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).toList();
        for (TypeElement parent : parents) {
            for (Element element2 : this.elements().getAllMembers(parent)) {
                if (element2.getKind() != ElementKind.METHOD || !(element2 instanceof ExecutableElement)) continue;
                ExecutableElement executable = (ExecutableElement)element2;
                Optional<ExecutableElement> mapValue = factory.apply(executable);
                mapValue.ifPresent(t -> possibleOverrides.computeIfAbsent(executable.getSimpleName().toString(), k -> new HashSet()).add(t));
            }
        }
        return Map.copyOf(possibleOverrides);
    }

    @Override
    public List<ExecutableElement> getAllOverriddenMethods(ExecutableElement element) {
        Element element2;
        if ((element.getEnclosingElement().getKind().isClass() || element.getEnclosingElement().getKind().isInterface()) && (element2 = element.getEnclosingElement()) instanceof TypeElement) {
            TypeElement type = (TypeElement)element2;
            String elemName = element.getSimpleName().toString();
            Map map = this.getPossibleOverrideMap(type, ex -> Optional.of(ex).filter(e -> elemName.equals(e.getSimpleName().toString())));
            if (!map.containsKey(elemName)) {
                return List.of();
            }
            return map.get(elemName).stream().filter(ex -> this.elements.overrides(element, (ExecutableElement)ex, type)).toList();
        }
        return List.of();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.roundEnv = roundEnv;
        this.run(annotations, roundEnv);
        return false;
    }

    public abstract void run(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public Set<String> getSupportedOptions() {
        return Set.of("mod.properties.mod_id", "mod.properties.mc_version", "mod.properties.mod_version", "mod.properties.java_version", "mod.properties.release");
    }
}

