/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.recipe;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.common.recipe.WrappedShapedRecipe;
import mekanism.tools.common.registries.ToolsRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

@NothingNullByDefault
public class PaxelRecipe
extends WrappedShapedRecipe {
    public PaxelRecipe(ShapedRecipe internal) {
        super(internal);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ToolsRecipeSerializers.PAXEL.get();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack resultItem = this.getResultItem(provider);
        if (resultItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack toReturn = resultItem.copy();
        if (!toReturn.isDamageableItem() || toReturn.isDamaged()) {
            return toReturn;
        }
        int totalDurability = 0;
        int totalMaxDurability = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.getItem().isDamageable(stack)) continue;
            int max = stack.getMaxDamage();
            totalDurability += max - stack.getDamageValue();
            totalMaxDurability += max;
        }
        if (totalDurability == totalMaxDurability) {
            return toReturn;
        }
        int maxDurability = toReturn.getMaxDamage();
        int targetDurability = MathUtils.clampToInt((double)((double)maxDurability * ((double)totalDurability / (double)totalMaxDurability)));
        if (targetDurability == 0) {
            return ItemStack.EMPTY;
        }
        if (targetDurability < maxDurability) {
            toReturn.setDamageValue(maxDurability - targetDurability);
        }
        return toReturn;
    }
}

