/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.wynnvp.wynncraftvp.ModCore;
import com.wynnvp.wynncraftvp.events.ReceiveChatEvent;
import com.wynnvp.wynncraftvp.utils.Utils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;

public class VersionChecker {
    public static boolean isOnUpToDateVersion = false;

    public static void checkVersion() {
        JsonObject jsonObject = VersionChecker.getVersionCheckFromWebsite();
        String fact = null;
        String killSwitchVersion = null;
        String newestVersion = null;
        String updateVersion = null;
        String directUpdateLink = null;
        String updateInfoPageLink = null;
        String azureBlobLink = null;
        ArrayList<String> audioUrls = new ArrayList<String>();
        ArrayList<String> broadcast = new ArrayList<String>();
        try {
            fact = jsonObject.get("fact").getAsString();
            killSwitchVersion = jsonObject.get("fabric_killSwitchVersion").getAsString();
            newestVersion = jsonObject.get("fabric_newestVersion").getAsString();
            updateVersion = jsonObject.get("fabric_updateNotification").getAsString();
            directUpdateLink = jsonObject.get("fabric_directUpdateLink").getAsString();
            updateInfoPageLink = jsonObject.get("fabric_updateInfopageLink").getAsString();
            azureBlobLink = jsonObject.get("azure_blob_link").getAsString();
            jsonObject.getAsJsonArray("audio_urls").forEach(jsonElement -> audioUrls.add(jsonElement.getAsString()));
            jsonObject.getAsJsonArray("broadcast").forEach(jsonElement -> broadcast.add(jsonElement.getAsString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (newestVersion == null) {
            return;
        }
        if (azureBlobLink != null) {
            ModCore.config.azureBlobLink = azureBlobLink;
            ModCore.config.save();
        }
        if (!audioUrls.isEmpty()) {
            ModCore.config.urls = audioUrls;
            ModCore.config.save();
        }
        String version = ModCore.instance.getVersion().substring(1);
        float versionInFloat = VersionChecker.GetVersionNumberInFloat(version);
        float killSwitchVersionInFloat = VersionChecker.GetVersionNumberInFloat(killSwitchVersion);
        assert (updateVersion != null);
        float updateVersionInFloat = VersionChecker.GetVersionNumberInFloat(updateVersion);
        if (killSwitchVersionInFloat >= versionInFloat) {
            ReceiveChatEvent.stopMod = true;
            String message1 = "\u00a78A game breaking bug was found on your version of \u00a75Voices of Wynn\u00a78 so the mod was disabled. Please update it";
            Utils.sendMessage(message1);
        }
        isOnUpToDateVersion = version.equals(newestVersion);
        if (versionInFloat > updateVersionInFloat) {
            if (fact != null && ModCore.config.isSendFunFact()) {
                Utils.sendMessage("\u00a79Fun fact: " + fact);
            }
            VersionChecker.showBroadcastMessages(broadcast);
            return;
        }
        Utils.sendMessage("\u00a79A new version of \u00a75Voices of Wynn\u00a79 is available! You are using version: \u00a74" + version + " \u00a79and the newest version is: \u00a72" + newestVersion + ".");
        Utils.appendMessageWithLinkAndSend("\u00a79To download it directly, click ", directUpdateLink, "\u00a7b\u00a7nhere");
        Utils.appendMessageWithLinkAndSend("\u00a79To see the changelog, click ", updateInfoPageLink, "\u00a7b\u00a7nhere");
        VersionChecker.showBroadcastMessages(broadcast);
    }

    private static void showBroadcastMessages(List<String> broadcast) {
        if (broadcast != null && !broadcast.isEmpty()) {
            for (String message : broadcast) {
                Utils.sendMessage("\u00a7d" + message);
            }
        }
    }

    private static float GetVersionNumberInFloat(String version) {
        version = version.replaceAll("[^\\d.]", "");
        float output = 0.0f;
        float multiplier = 1.0f;
        for (String str : version.split("\\.")) {
            output += Float.parseFloat(str) / multiplier;
            multiplier *= 10.0f;
        }
        return output;
    }

    private static JsonObject getVersionCheckFromWebsite() {
        String hashedUUID = Utils.sha256(class_310.method_1551().field_1724.method_5667().toString());
        String url = "http://voicesofwynn.com/api/version/check?id=" + hashedUUID;
        JsonObject jsonObject = null;
        try {
            jsonObject = VersionChecker.getJsonData(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private static JsonObject getJsonData(String urlToRead) throws Exception {
        StringBuilder result = new StringBuilder();
        URL url = new URL(urlToRead);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        JsonParser jsonParser = new JsonParser();
        return jsonParser.parse(result.toString()).getAsJsonObject();
    }
}

