/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ChatUtils {
    private static final Pattern NPC_CONFIRM_PATTERN = Pattern.compile("Press (SNEAK|SHIFT) to continue");
    private static final Pattern NPC_SELECT_PATTERN = Pattern.compile("(Select|CLICK) an option to continue");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\n");

    public static String extractMessage(String messageAsString) {
        if (messageAsString.contains("\n") && messageAsString.indexOf(10) != messageAsString.length() - 1) {
            return ChatUtils.getMessageFromDialogueScreen(messageAsString);
        }
        return messageAsString;
    }

    private static String getMessageFromDialogueScreen(String message) {
        LinkedList<String> lines = ChatUtils.getChatMessages(message);
        Collections.reverse(lines);
        LinkedList<String> newLines = new LinkedList<String>(lines);
        String firstLine = newLines.getFirst();
        boolean isNpcConfirm = NPC_CONFIRM_PATTERN.matcher(firstLine).find();
        boolean isNpcSelect = NPC_SELECT_PATTERN.matcher(firstLine).find();
        if (isNpcConfirm || isNpcSelect) {
            newLines.removeFirst();
        }
        if (newLines.size() == 0) {
            return "";
        }
        while (!newLines.isEmpty() && (newLines.getFirst().isEmpty() || newLines.getFirst().startsWith("   "))) {
            newLines.removeFirst();
        }
        if (newLines.isEmpty()) {
            return "";
        }
        return newLines.getFirst();
    }

    private static LinkedList<String> getChatMessages(String message) {
        String segment;
        Matcher matcher = NEWLINE_PATTERN.matcher(message);
        LinkedList<String> lines = new LinkedList<String>();
        int lastSegmentStart = 0;
        while (matcher.find()) {
            segment = message.substring(lastSegmentStart, matcher.start());
            lines.add(segment);
            lastSegmentStart = matcher.end();
        }
        if (lastSegmentStart != message.length()) {
            segment = message.substring(lastSegmentStart);
            lines.add(segment);
        }
        return lines;
    }
}

