/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.text;

import com.wynnvp.wynncraftvp.text.PartStyle;
import com.wynnvp.wynncraftvp.text.StyledText;
import com.wynnvp.wynncraftvp.text.StyledTextPart;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class StyledTextUtils {
    private static final Pattern COORDINATE_PATTERN = Pattern.compile(".*\\[(-?\\d+)(?:.\\d+)?, ?(-?\\d+)(?:.\\d+)?, ?(-?\\d+)(?:.\\d+)?\\].*");
    private static final String NEWLINE_PREPARATION = "\n";
    private static final Pattern NEWLINE_WRAP_PATTERN = Pattern.compile("\udaff\udffc\ue001\udb00\udc06");

    public static List<StyledText> splitInLines(StyledText styledText) {
        ArrayList<StyledText> newLines = new ArrayList<StyledText>();
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        for (StyledTextPart part : styledText) {
            String partString = part.getString(null, PartStyle.StyleType.NONE);
            if (partString.equals(NEWLINE_PREPARATION)) {
                newLines.add(StyledText.fromParts(parts));
                parts.clear();
                continue;
            }
            parts.add(part);
        }
        if (!parts.isEmpty()) {
            newLines.add(StyledText.fromParts(parts));
        }
        return newLines;
    }
}

