/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.text;

import com.google.common.collect.Iterables;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.wynnvp.wynncraftvp.text.Pair;
import com.wynnvp.wynncraftvp.text.PartStyle;
import com.wynnvp.wynncraftvp.text.StyledTextPart;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public final class StyledText
implements Iterable<StyledTextPart> {
    private static final char POSITIVE_SPACE_HIGH_SURROGATE = '\udb00';
    private static final char NEGATIVE_SPACE_HIGH_SURROGATE = '\udaff';
    public static final StyledText EMPTY = new StyledText(List.of(), List.of(), List.of());
    private final List<StyledTextPart> parts;
    private final List<class_2558> clickEvents;
    private final List<class_2568> hoverEvents;

    public List<class_2568> getHoverEvents() {
        return this.hoverEvents;
    }

    private StyledText(List<StyledTextPart> parts, List<class_2558> clickEvents, List<class_2568> hoverEvents) {
        this.parts = parts.stream().filter(styledTextPart -> !styledTextPart.isEmpty()).map(styledTextPart -> new StyledTextPart((StyledTextPart)styledTextPart, this)).collect(Collectors.toList());
        this.clickEvents = Collections.unmodifiableList(clickEvents);
        this.hoverEvents = Collections.unmodifiableList(hoverEvents);
    }

    public static StyledText fromComponent(class_2561 component) {
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        LinkedList<Pair<class_2561, class_2583>> deque = new LinkedList<Pair<class_2561, class_2583>>();
        deque.add(new Pair<class_2561, class_2583>(component, class_2583.field_24360));
        while (!deque.isEmpty()) {
            Pair currentPair = (Pair)deque.pop();
            class_2561 current = (class_2561)currentPair.key();
            class_2583 parentStyle = (class_2583)currentPair.value();
            String componentString = class_5250.method_43477((class_7417)current.method_10851()).getString();
            List<StyledTextPart> styledTextParts = StyledTextPart.fromCodedString(componentString, current.method_10866(), null, parentStyle);
            class_2583 styleToFollowForChildren = current.method_10866().method_27702(parentStyle);
            List<Pair> siblingPairs = current.method_10855().stream().map(sibling -> new Pair<class_2561, class_2583>((class_2561)sibling, styleToFollowForChildren)).collect(Collectors.toList());
            Collections.reverse(siblingPairs);
            siblingPairs.forEach(deque::addFirst);
            parts.addAll(styledTextParts.stream().filter(part -> !part.isEmpty()).toList());
        }
        return StyledText.fromParts(parts);
    }

    public static StyledText fromString(String codedString) {
        return new StyledText(StyledTextPart.fromCodedString(codedString, class_2583.field_24360, null, class_2583.field_24360), List.of(), List.of());
    }

    public static StyledText fromModifiedString(String codedString, StyledText styledText) {
        List<class_2568> hoverEvents = List.copyOf(styledText.hoverEvents);
        List<class_2558> clickEvents = List.copyOf(styledText.clickEvents);
        return new StyledText(StyledTextPart.fromCodedString(codedString, class_2583.field_24360, styledText, class_2583.field_24360), clickEvents, hoverEvents);
    }

    public static StyledText fromUnformattedString(String unformattedString) {
        StyledTextPart part = new StyledTextPart(unformattedString, class_2583.field_24360, null, class_2583.field_24360);
        return new StyledText(List.of(part), List.of(), List.of());
    }

    public static StyledText fromPart(StyledTextPart part) {
        return StyledText.fromParts(List.of(part));
    }

    public static StyledText fromParts(List<StyledTextPart> parts) {
        ArrayList<class_2558> clickEvents = new ArrayList<class_2558>();
        ArrayList<class_2568> hoverEvents = new ArrayList<class_2568>();
        for (StyledTextPart part : parts) {
            class_2568 hoverEvent;
            class_2558 clickEvent = part.getPartStyle().getClickEvent();
            if (clickEvent != null && !clickEvents.contains(clickEvent)) {
                clickEvents.add(clickEvent);
            }
            if ((hoverEvent = part.getPartStyle().getHoverEvent()) == null || hoverEvents.contains(hoverEvent)) continue;
            hoverEvents.add(hoverEvent);
        }
        return new StyledText(parts, clickEvents, hoverEvents);
    }

    public String getString(PartStyle.StyleType type) {
        StringBuilder builder = new StringBuilder();
        PartStyle previousStyle = null;
        for (StyledTextPart part : this.parts) {
            builder.append(part.getString(previousStyle, type));
            previousStyle = part.getPartStyle();
        }
        return builder.toString();
    }

    public String getString() {
        return this.getString(PartStyle.StyleType.DEFAULT);
    }

    public String getStringWithoutFormatting() {
        return this.getString(PartStyle.StyleType.NONE);
    }

    public int length() {
        return this.parts.stream().mapToInt(StyledTextPart::length).sum();
    }

    public int length(PartStyle.StyleType styleType) {
        return this.getString(styleType).length();
    }

    public static StyledText join(StyledText styledTextSeparator, StyledText ... texts) {
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        int length = texts.length;
        for (int i = 0; i < length; ++i) {
            StyledText text = texts[i];
            parts.addAll(text.parts);
            if (i == length - 1) continue;
            parts.addAll(styledTextSeparator.parts);
        }
        return StyledText.fromParts(parts);
    }

    public static StyledText join(StyledText styledTextSeparator, Iterable<StyledText> texts) {
        return StyledText.join(styledTextSeparator, (StyledText[])Iterables.toArray(texts, StyledText.class));
    }

    public static StyledText join(String codedStringSeparator, StyledText ... texts) {
        return StyledText.join(StyledText.fromString(codedStringSeparator), texts);
    }

    public static StyledText join(String codedStringSeparator, Iterable<StyledText> texts) {
        return StyledText.join(StyledText.fromString(codedStringSeparator), (StyledText[])Iterables.toArray(texts, StyledText.class));
    }

    public static StyledText concat(StyledText ... texts) {
        return StyledText.fromParts(Arrays.stream(texts).map(text -> text.parts).flatMap(Collection::stream).toList());
    }

    public static StyledText concat(Iterable<StyledText> texts) {
        return StyledText.concat((StyledText[])Iterables.toArray(texts, StyledText.class));
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public boolean isBlank() {
        return this.parts.stream().allMatch(StyledTextPart::isBlank);
    }

    public boolean contains(String codedString) {
        return this.contains(codedString, PartStyle.StyleType.DEFAULT);
    }

    public boolean contains(StyledText styledText) {
        return this.contains(styledText.getString(PartStyle.StyleType.DEFAULT), PartStyle.StyleType.DEFAULT);
    }

    public boolean contains(String codedString, PartStyle.StyleType styleType) {
        return this.getString(styleType).contains(codedString);
    }

    public boolean contains(StyledText styledText, PartStyle.StyleType styleType) {
        return this.contains(styledText.getString(styleType), styleType);
    }

    public boolean startsWith(String codedString) {
        return this.startsWith(codedString, PartStyle.StyleType.DEFAULT);
    }

    public boolean startsWith(StyledText styledText) {
        return this.startsWith(styledText.getString(PartStyle.StyleType.DEFAULT), PartStyle.StyleType.DEFAULT);
    }

    public boolean startsWith(String codedString, PartStyle.StyleType styleType) {
        return this.getString(styleType).startsWith(codedString);
    }

    public boolean startsWith(StyledText styledText, PartStyle.StyleType styleType) {
        return this.startsWith(styledText.getString(styleType), styleType);
    }

    public boolean endsWith(String codedString) {
        return this.endsWith(codedString, PartStyle.StyleType.DEFAULT);
    }

    public boolean endsWith(StyledText styledText) {
        return this.endsWith(styledText.getString(PartStyle.StyleType.DEFAULT), PartStyle.StyleType.DEFAULT);
    }

    public boolean endsWith(String codedString, PartStyle.StyleType styleType) {
        return this.getString(styleType).endsWith(codedString);
    }

    public boolean endsWith(StyledText styledText, PartStyle.StyleType styleType) {
        return this.endsWith(styledText.getString(styleType), styleType);
    }

    public Matcher getMatcher(Pattern pattern) {
        return this.getMatcher(pattern, PartStyle.StyleType.DEFAULT);
    }

    public Matcher getMatcher(Pattern pattern, PartStyle.StyleType styleType) {
        return pattern.matcher(this.getString(styleType));
    }

    public boolean matches(Pattern pattern) {
        return this.matches(pattern, PartStyle.StyleType.DEFAULT);
    }

    public boolean matches(Pattern pattern, PartStyle.StyleType styleType) {
        return pattern.matcher(this.getString(styleType)).matches();
    }

    public boolean find(Pattern pattern) {
        return this.find(pattern, PartStyle.StyleType.DEFAULT);
    }

    public boolean find(Pattern pattern, PartStyle.StyleType styleType) {
        return pattern.matcher(this.getString(styleType)).find();
    }

    public StyledText append(StyledText styledText) {
        return StyledText.concat(this, styledText);
    }

    public StyledText append(String codedString) {
        return this.append(StyledText.fromString(codedString));
    }

    public StyledText appendPart(StyledTextPart part) {
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>(this.parts);
        newParts.add(part);
        return StyledText.fromParts(newParts);
    }

    public StyledText prepend(StyledText styledText) {
        return StyledText.concat(styledText, this);
    }

    public StyledText prepend(String codedString) {
        return this.prepend(StyledText.fromString(codedString));
    }

    public StyledText prependPart(StyledTextPart part) {
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>(this.parts);
        newParts.addFirst(part);
        return StyledText.fromParts(newParts);
    }

    public boolean equalsString(String string) {
        return this.equalsString(string, PartStyle.StyleType.DEFAULT);
    }

    public boolean equalsString(String string, PartStyle.StyleType styleType) {
        return this.getString(styleType).equals(string);
    }

    public StyledTextPart getFirstPart() {
        if (this.parts.isEmpty()) {
            return null;
        }
        return this.parts.getFirst();
    }

    public StyledTextPart getLastPart() {
        if (this.parts.isEmpty()) {
            return null;
        }
        return this.parts.getLast();
    }

    public int getPartCount() {
        return this.parts.size();
    }

    public int getClickEventIndex(class_2558 clickEvent) {
        for (int i = 0; i < this.clickEvents.size(); ++i) {
            class_2558 event = this.clickEvents.get(i);
            if (!event.equals((Object)clickEvent)) continue;
            return i + 1;
        }
        return -1;
    }

    class_2558 getClickEvent(int index) {
        return (class_2558)Iterables.get(this.clickEvents, (int)(index - 1), null);
    }

    public int getHoverEventIndex(class_2568 hoverEvent) {
        for (int i = 0; i < this.hoverEvents.size(); ++i) {
            class_2568 event = this.hoverEvents.get(i);
            if (!event.equals((Object)hoverEvent)) continue;
            return i + 1;
        }
        return -1;
    }

    class_2568 getHoverEvent(int index) {
        return (class_2568)Iterables.get(this.hoverEvents, (int)(index - 1), null);
    }

    private StyledTextPart getPartBefore(StyledTextPart part) {
        int index = this.parts.indexOf(part);
        if (index == 0) {
            return null;
        }
        return this.parts.get(index - 1);
    }

    @Override
    public Iterator<StyledTextPart> iterator() {
        return this.parts.iterator();
    }

    public String toString() {
        return "StyledText{'" + this.getString(PartStyle.StyleType.INCLUDE_EVENTS) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyledText that = (StyledText)o;
        return Objects.deepEquals(this.parts, that.parts) && Objects.deepEquals(this.clickEvents, that.clickEvents) && Objects.deepEquals(this.hoverEvents, that.hoverEvents);
    }

    public int hashCode() {
        return Objects.hash(this.parts, this.clickEvents, this.hoverEvents);
    }

    public static class StyledTextSerializer
    implements JsonSerializer<StyledText>,
    JsonDeserializer<StyledText> {
        public StyledText deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return StyledText.fromString(json.getAsString());
        }

        public JsonElement serialize(StyledText src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.getString());
        }
    }
}

