/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.text;

import com.wynnvp.wynncraftvp.text.MessageType;
import com.wynnvp.wynncraftvp.text.StyledText;
import java.util.regex.Pattern;

public enum RecipientType {
    INFO(null, null, "Info"),
    CLIENTSIDE(null, null, "Clientside"),
    NPC("^\u00a77\\[\\d+\\/\\d+\\](?:\u00a7.)? ?\u00a7[25] ?.+: ?\u00a7..*$", "^\u00a78\\[\\d+\\/\\d+\\] .+: ?\u00a7..*$", "NPC"),
    GLOBAL("^\u00a77\ue056\ue042[\ue060-\ue069]{1,3}\u00a7r .+", "\u00a77\ue056\ue042[\ue060-\ue069]{1,3}\u00a7r .+", "Global"),
    LOCAL("^\u00a7f\ue056\ue042[\ue060-\ue069]{1,3}(?:\u00a7r)? .+", "^\u00a78\ue056\ue042[\ue060-\ue069]{1,3}\u00a7r .+", "Local"),
    GUILD("^\u00a7b((\udaff\udffc\ue006\udaff\udfff\ue002\udaff\udffe)|(\udaff\udffc\ue001\udb00\udc06)).*$", "^\u00a78((\udaff\udffc\ue006\udaff\udfff\ue002\udaff\udffe)|(\udaff\udffc\ue001\udb00\udc06)).*$", "Guild"),
    PARTY("^\u00a7e((\udaff\udffc\ue005\udaff\udfff\ue002\udaff\udffe)|(\udaff\udffc\ue001\udb00\udc06)) .*$", "^\u00a78((\udaff\udffc\ue005\udaff\udfff\ue002\udaff\udffe)|(\udaff\udffc\ue001\udb00\udc06)) .*$", "Party"),
    PRIVATE("^\u00a76((\udaff\udffc\ue007\udaff\udfff\ue002\udaff\udffe)|(\udaff\udffc\ue001\udb00\udc06)) .* \ue003 .*:\u00a76 \u00a7f.*$", "^\u00a78\udaff\udffc.* .* \ue003 .*:\u00a78 .*$", "Private"),
    SHOUT("^\u00a75.* \\[[A-Z0-9]+\\] shouts: \u00a7d.*$", "^(\u00a78)?.* \\[[A-Z0-9]+\\] shouts: \u00a77.*$", "Shout"),
    PETS("^\u00a72(.*): \u00a7a(.*)$", "^\u00a78(.*): \u00a77(.*)$", "Pets"),
    GAME_MESSAGE("^\u00a7(4|c|6|7)[A-Za-z0-9].*$", null, "Game Message");

    private final Pattern foregroundPattern;
    private final Pattern backgroundPattern;
    private final String name;

    private RecipientType(String foregroundPattern, String backgroundPattern, String name) {
        this.foregroundPattern = foregroundPattern == null ? null : Pattern.compile(foregroundPattern, 32);
        this.backgroundPattern = backgroundPattern == null ? null : Pattern.compile(backgroundPattern, 32);
        this.name = name;
    }

    public boolean matchPattern(StyledText msg, MessageType messageType) {
        Pattern pattern;
        Pattern pattern2 = pattern = messageType == MessageType.FOREGROUND ? this.foregroundPattern : this.backgroundPattern;
        if (pattern == null) {
            return false;
        }
        return msg.getMatcher(pattern).matches();
    }

    public static RecipientType fromName(String string) {
        for (RecipientType type : RecipientType.values()) {
            if (!type.name.equalsIgnoreCase(string)) continue;
            return type;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }
}

