/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.text;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;

public class CustomColor {
    public static final CustomColor NONE = new CustomColor(-1, -1, -1, -1);
    private static final Pattern HEX_PATTERN = Pattern.compile("#?([0-9a-fA-F]{6})([0-9a-fA-F]{2})?");
    private static final Pattern STRING_PATTERN = Pattern.compile("rgba\\((\\d+),(\\d+),(\\d+),(\\d+)\\)");
    private static final Map<String, CustomColor> REGISTERED_HASHED_COLORS = new HashMap<String, CustomColor>();
    public final int r;
    public final int g;
    public final int b;
    public final int a;

    public CustomColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public CustomColor(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public CustomColor(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public CustomColor(float r, float g, float b, float a) {
        this.r = (int)(r * 255.0f);
        this.g = (int)(g * 255.0f);
        this.b = (int)(b * 255.0f);
        this.a = (int)(a * 255.0f);
    }

    public CustomColor(CustomColor color) {
        this(color.r, color.g, color.b, color.a);
    }

    public CustomColor(CustomColor color, int alpha) {
        this(color.r, color.g, color.b, alpha);
    }

    public CustomColor(String toParse) {
        String noSpace = toParse.replace(" ", "");
        CustomColor parseTry = CustomColor.fromString(noSpace);
        if (parseTry == NONE && (parseTry = CustomColor.fromHexString(noSpace)) == NONE) {
            throw new RuntimeException("Failed to parse CustomColor");
        }
        this.r = parseTry.r;
        this.g = parseTry.g;
        this.b = parseTry.b;
        this.a = parseTry.a;
    }

    public static CustomColor fromChatFormatting(class_124 cf) {
        return CustomColor.fromInt(cf.method_532() | 0xFF000000);
    }

    public static CustomColor fromInt(int num) {
        if ((num & 0xFF000000) == 0) {
            num |= 0xFF000000;
        }
        return new CustomColor(num >> 16 & 0xFF, num >> 8 & 0xFF, num & 0xFF, num >> 24 & 0xFF);
    }

    public static CustomColor fromHexString(String hex) {
        Matcher hexMatcher = HEX_PATTERN.matcher(hex.trim());
        if (!hexMatcher.matches()) {
            return NONE;
        }
        if (hexMatcher.group(2) == null) {
            return CustomColor.fromInt(Integer.parseInt(hexMatcher.group(1), 16)).withAlpha(255);
        }
        return CustomColor.fromInt(Integer.parseInt(hexMatcher.group(1), 16)).withAlpha(Integer.parseInt(hexMatcher.group(2), 16));
    }

    public static CustomColor fromString(String string) {
        Matcher stringMatcher = STRING_PATTERN.matcher(string.trim());
        if (!stringMatcher.matches()) {
            return NONE;
        }
        return new CustomColor(Integer.parseInt(stringMatcher.group(1)), Integer.parseInt(stringMatcher.group(2)), Integer.parseInt(stringMatcher.group(3)), Integer.parseInt(stringMatcher.group(4)));
    }

    public CustomColor withAlpha(int a) {
        return new CustomColor(this, a);
    }

    public CustomColor withAlpha(float a) {
        return new CustomColor(this, (int)(a * 255.0f));
    }

    public int asInt() {
        int a = Math.min(this.a, 255);
        int r = Math.min(this.r, 255);
        int g = Math.min(this.g, 255);
        int b = Math.min(this.b, 255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public float[] asFloatArray() {
        return new float[]{(float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f};
    }

    public String toHexString() {
        return "#" + String.format("%08x", this.r << 24 | this.g << 16 | this.b << 8 | this.a);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CustomColor)) {
            return false;
        }
        CustomColor color = (CustomColor)obj;
        return this.r == color.r && this.g == color.g && this.b == color.b && this.a == color.a;
    }

    public String toString() {
        return this.toHexString();
    }

    public static class CustomColorSerializer
    implements JsonSerializer<CustomColor>,
    JsonDeserializer<CustomColor> {
        public CustomColor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            CustomColor customColor = CustomColor.fromHexString(json.getAsString());
            return customColor == NONE ? CustomColor.fromString(json.getAsString()) : customColor;
        }

        public JsonElement serialize(CustomColor src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.toString());
        }
    }
}

