/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.text;

import com.wynnvp.wynncraftvp.events.ReceiveChatEvent;
import com.wynnvp.wynncraftvp.text.MessageType;
import com.wynnvp.wynncraftvp.text.NpcDialogueType;
import com.wynnvp.wynncraftvp.text.RecipientType;
import com.wynnvp.wynncraftvp.text.StyledText;
import com.wynnvp.wynncraftvp.text.StyledTextUtils;
import com.wynnvp.wynncraftvp.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2718;
import net.minecraft.class_2783;
import net.minecraft.class_310;

public final class ChatHandler {
    private static final Pattern NPC_CONFIRM_PATTERN = Pattern.compile("^ *\u00a7[47]Press \u00a7[cf](SNEAK|SHIFT) \u00a7[47]to continue$");
    private static final Pattern NPC_SELECT_PATTERN = Pattern.compile("^ *\u00a7[47cf](Select|CLICK) \u00a7[47cf]an option (\u00a7[47])?to continue$");
    private static final Pattern EMPTY_LINE_PATTERN = Pattern.compile("^\\s*(\u00a7r|\u00c0+)?\\s*$");
    private static final long SLOWDOWN_PACKET_TICK_DELAY = 20L;
    private static final int CHAT_SCREEN_TICK_DELAY = 1;
    private String lastRealChat = null;
    private String oneBeforeLastRealChat = null;
    private long lastSlowdownApplied = 0L;
    private List<StyledText> lastScreenNpcDialogue = List.of();
    private StyledText lastConfirmationlessDialogue = null;
    private List<StyledText> delayedDialogue;
    private NpcDialogueType delayedType = NpcDialogueType.NONE;
    private long chatScreenTicks = 0L;
    private List<StyledText> collectedLines = new ArrayList<StyledText>();
    private boolean updateWrongOrder = false;

    private void updateWrongOrderPackets() {
        this.updateWrongOrder = false;
        if (this.delayedDialogue != null) {
            List<StyledText> dialogToSend = this.delayedDialogue;
            this.delayedDialogue = null;
            this.handleNpcDialogue(dialogToSend, this.delayedType, false);
        }
    }

    public void onConnectionChange() {
        this.collectedLines = new ArrayList<StyledText>();
        this.chatScreenTicks = 0L;
        this.lastRealChat = null;
        this.oneBeforeLastRealChat = null;
        this.lastSlowdownApplied = 0L;
        this.lastScreenNpcDialogue = List.of();
        this.lastConfirmationlessDialogue = null;
        this.delayedDialogue = null;
        this.delayedType = NpcDialogueType.NONE;
    }

    public void onTick() {
        if (this.updateWrongOrder) {
            this.updateWrongOrderPackets();
        }
        if (this.collectedLines.isEmpty()) {
            return;
        }
        long ticks = Utils.mc().field_1687.method_75260();
        if (ticks >= this.chatScreenTicks + 1L) {
            this.processCollectedChatScreen();
        }
    }

    public void onChatReceived(class_2561 messageComponent) {
        this.handleWithSeparation(messageComponent);
    }

    public void onStatusEffectUpdate(class_2783 event) {
        if (Utils.mc().field_1687.method_8469(event.method_11943()) != Utils.player()) {
            return;
        }
        if (event.method_11946().equals(class_1294.field_5909.comp_349()) && event.method_11945() == 3 && event.method_11944() == Short.MAX_VALUE) {
            if (this.delayedDialogue != null) {
                List<StyledText> dialogue = this.delayedDialogue;
                this.delayedDialogue = null;
                this.handleNpcDialogue(dialogue, this.delayedType, true);
            } else {
                this.lastSlowdownApplied = Utils.mc().field_1687.method_75260();
            }
        }
    }

    public void onStatusEffectRemove(class_2718 event) {
        if (event.method_11767((class_1937)Utils.mc().field_1687) != Utils.player()) {
            return;
        }
        if (event.comp_2176() == class_1294.field_5909) {
            this.lastSlowdownApplied = 0L;
        }
    }

    private void handleIncomingChatLine(class_2561 messageComponent) {
        StyledText styledText = StyledText.fromComponent(messageComponent);
        StyledText updatedMessage = this.postChatLine(styledText, MessageType.FOREGROUND);
        if (updatedMessage != null) {
            RecipientType recipientType = this.getRecipientType(styledText, MessageType.FOREGROUND);
        }
    }

    private void handleWithSeparation(class_2561 componentMessage) {
        StyledText styledText = StyledText.fromComponent(componentMessage);
        long currentTicks = Utils.mc().field_1687.method_75260();
        List<StyledText> lines = StyledTextUtils.splitInLines(styledText);
        if (lines.size() > 1 || styledText.isEmpty() && currentTicks <= this.chatScreenTicks + 1L) {
            if (currentTicks <= this.chatScreenTicks + 1L) {
                this.collectedLines.addAll(lines);
            } else {
                if (this.chatScreenTicks != 0L) {
                    this.processCollectedChatScreen();
                }
                this.collectedLines = new ArrayList<StyledText>(lines);
                this.chatScreenTicks = currentTicks;
            }
        } else {
            if (this.chatScreenTicks != 0L) {
                this.processCollectedChatScreen();
            }
            this.handleIncomingChatLine(componentMessage);
        }
    }

    private void processCollectedChatScreen() {
        ArrayList<StyledText> lines = new ArrayList<StyledText>(this.collectedLines);
        this.collectedLines = new ArrayList<StyledText>();
        this.chatScreenTicks = 0L;
        Collections.reverse(lines);
        LinkedList<StyledText> newLines = new LinkedList<StyledText>();
        if (this.lastRealChat == null) {
            lines.forEach(newLines::addLast);
        } else {
            StyledText line;
            String plainText;
            Iterator iterator = lines.iterator();
            while (iterator.hasNext() && !(plainText = (line = (StyledText)iterator.next()).getStringWithoutFormatting()).equals(this.lastRealChat)) {
                if (plainText.equals(this.oneBeforeLastRealChat)) {
                    this.lastRealChat = this.oneBeforeLastRealChat;
                    this.oneBeforeLastRealChat = null;
                    break;
                }
                newLines.addLast(line);
            }
        }
        if (newLines.isEmpty()) {
            this.handleNpcDialogue(List.of(), NpcDialogueType.NONE, false);
            return;
        }
        boolean expectedConfirmationlessDialogue = false;
        if (((StyledText)newLines.getLast()).getString().isEmpty()) {
            if (newLines.size() == 2) {
                if (newLines.getFirst().matches(EMPTY_LINE_PATTERN)) {
                    return;
                }
                expectedConfirmationlessDialogue = true;
            } else if (newLines.size() == 4 && newLines.get(0).matches(EMPTY_LINE_PATTERN) && newLines.get(1).matches(EMPTY_LINE_PATTERN) && !newLines.get(2).matches(EMPTY_LINE_PATTERN) && newLines.get(3).matches(EMPTY_LINE_PATTERN)) {
                expectedConfirmationlessDialogue = true;
                newLines.removeFirst();
                newLines.removeFirst();
            }
            newLines.removeLast();
        }
        this.processNewLines(newLines, expectedConfirmationlessDialogue);
    }

    private void processNewLines(LinkedList<StyledText> newLines, boolean expectedConfirmationlessDialogue) {
        LinkedList<StyledText> newChatLines = new LinkedList<StyledText>();
        LinkedList<StyledText> dialogue = new LinkedList<StyledText>();
        if (newLines.isEmpty()) {
            return;
        }
        StyledText firstText = newLines.getFirst();
        boolean isNpcConfirm = firstText.find(NPC_CONFIRM_PATTERN);
        boolean isNpcSelect = firstText.find(NPC_SELECT_PATTERN);
        if (isNpcConfirm || isNpcSelect) {
            newLines.removeFirst();
            if (newLines.isEmpty()) {
                return;
            }
            if (newLines.getFirst().getString().isEmpty()) {
                newLines.removeFirst();
            }
            boolean dialogDone = false;
            boolean optionsFound = !isNpcSelect;
            for (StyledText line : newLines) {
                if (!dialogDone) {
                    if (line.find(EMPTY_LINE_PATTERN)) {
                        if (!optionsFound) {
                            optionsFound = true;
                            dialogue.push(line);
                            continue;
                        }
                        dialogDone = true;
                        continue;
                    }
                    dialogue.push(line);
                    continue;
                }
                if (line.find(EMPTY_LINE_PATTERN)) continue;
                newChatLines.push(line);
            }
        } else {
            if (expectedConfirmationlessDialogue) {
                this.handleNpcDialogue(List.of(newLines.getFirst()), NpcDialogueType.CONFIRMATIONLESS, false);
                return;
            }
            while (!newLines.isEmpty() && newLines.getFirst().find(EMPTY_LINE_PATTERN)) {
                newLines.removeFirst();
            }
            Collections.reverse(newLines);
            while (!newLines.isEmpty()) {
                StyledText line = newLines.removeFirst();
                if (line.find(EMPTY_LINE_PATTERN)) {
                    StyledText nextLine;
                    if (newLines.isEmpty() || (nextLine = newLines.getFirst()).equals(this.lastConfirmationlessDialogue)) break;
                    for (StyledText dialogueLine : this.lastScreenNpcDialogue) {
                        StyledText nextDialogueLine;
                        if (newLines.isEmpty() || !(nextDialogueLine = newLines.getFirst()).equals(dialogueLine)) break;
                        newLines.removeFirst();
                    }
                    if (newLines.isEmpty()) break;
                }
                newChatLines.addLast(line);
            }
        }
        newChatLines.forEach(this::handleFakeChatLine);
        this.handleScreenNpcDialog(dialogue, isNpcSelect);
    }

    private void handleScreenNpcDialog(List<StyledText> dialogues, boolean isSelection) {
        NpcDialogueType type;
        if (dialogues.isEmpty()) {
            this.handleNpcDialogue(dialogues, NpcDialogueType.NONE, false);
            return;
        }
        NpcDialogueType npcDialogueType = type = isSelection ? NpcDialogueType.SELECTION : NpcDialogueType.NORMAL;
        if (Utils.mc().field_1687.method_75260() <= this.lastSlowdownApplied + 20L) {
            this.handleNpcDialogue(dialogues, type, true);
            return;
        }
        this.delayedDialogue = dialogues;
        this.delayedType = type;
        this.updateWrongOrder = true;
    }

    private void handleFakeChatLine(StyledText styledText) {
        if (styledText.isEmpty()) {
            return;
        }
        RecipientType recipientType = this.getRecipientType(styledText, MessageType.FOREGROUND);
        if (recipientType == RecipientType.NPC) {
            this.handleNpcDialogue(List.of(styledText), NpcDialogueType.CONFIRMATIONLESS, false);
            return;
        }
        StyledText updatedMessage = this.postChatLine(styledText, MessageType.BACKGROUND);
        if (updatedMessage == null) {
            return;
        }
    }

    private StyledText postChatLine(StyledText styledText, MessageType messageType) {
        RecipientType recipientType;
        String plainText = styledText.getStringWithoutFormatting();
        if (!plainText.isBlank()) {
            this.oneBeforeLastRealChat = this.lastRealChat;
            this.lastRealChat = plainText;
        }
        if ((recipientType = this.getRecipientType(styledText, messageType)) == RecipientType.GAME_MESSAGE) {
            this.onNpcDialogue(List.of(styledText), false, NpcDialogueType.NONE);
        }
        if (recipientType == RecipientType.NPC) {
            this.handleNpcDialogue(List.of(styledText), NpcDialogueType.CONFIRMATIONLESS, false);
            return null;
        }
        return styledText;
    }

    private void handleNpcDialogue(List<StyledText> dialogue, NpcDialogueType type, boolean isProtected) {
        if (type == NpcDialogueType.NONE) {
            this.delayedDialogue = null;
        }
        if (type == NpcDialogueType.CONFIRMATIONLESS) {
            this.lastConfirmationlessDialogue = dialogue.getFirst();
        } else {
            if (this.lastScreenNpcDialogue.equals(dialogue)) {
                return;
            }
            this.lastScreenNpcDialogue = dialogue;
        }
        this.onNpcDialogue(dialogue, isProtected, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onNpcDialogue(List<StyledText> dialogue, boolean isProtected, NpcDialogueType type) {
        Iterator<StyledText> iterator = dialogue.iterator();
        while (iterator.hasNext()) {
            StyledText text = iterator.next();
            String playerName = class_310.method_1551().field_1724.method_5477().getString();
            List<class_2568> hoverEvents = text.getHoverEvents();
            for (class_2568 hoverEvent : hoverEvents) {
                if (!(hoverEvent instanceof class_2568.class_10613)) continue;
                class_2568.class_10613 class_106132 = (class_2568.class_10613)hoverEvent;
                try {
                    // empty try
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                class_2561 class_25612 = class_106132.comp_3510();
                class_2561 showText = class_25612;
                String value = showText.getString();
                if (!value.contains("real username")) continue;
                playerName = value.split("'s real username")[0];
            }
            ReceiveChatEvent.receivedChat(text.getStringWithoutFormatting().replace(playerName, "soldier"));
        }
        return;
    }

    private RecipientType getRecipientType(StyledText codedMessage, MessageType messageType) {
        for (RecipientType recipientType : RecipientType.values()) {
            if (!recipientType.matchPattern(codedMessage, messageType)) continue;
            return recipientType;
        }
        return RecipientType.INFO;
    }
}

