/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound.player;

import com.wynnvp.wynncraftvp.ModCore;
import com.wynnvp.wynncraftvp.sound.Reverb;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.EXTEfx;

public class ReverbPresets {
    private static final ReverbParams OUTSIDE = new ReverbParams(1.0f, 1.0f, 0.316f, 0.447f, 1.5f, 0.5f, 0.05f, 0.007f, 0.251f, 0.011f, 0.994f, 0.0f, 1);
    private static final ReverbParams FOREST = new ReverbParams(1.0f, 0.85f, 0.316f, 0.562f, 1.2f, 0.6f, 0.1f, 0.01f, 0.2f, 0.015f, 0.97f, 0.0f, 1);
    private static final ReverbParams FURNISHED_ROOM = new ReverbParams(1.0f, 1.0f, 0.316f, 0.562f, 0.4f, 0.83f, 0.15f, 0.002f, 0.1f, 0.003f, 0.994f, 0.0f, 1);
    private static final ReverbParams EMPTY_ROOM = new ReverbParams(1.0f, 1.0f, 0.316f, 0.794f, 1.1f, 0.89f, 0.4f, 0.002f, 0.5f, 0.003f, 0.994f, 0.0f, 1);
    private static final ReverbParams HALLWAY = new ReverbParams(1.0f, 0.9f, 0.316f, 0.707f, 0.8f, 0.75f, 0.3f, 0.005f, 0.35f, 0.008f, 0.994f, 0.0f, 1);
    private static final ReverbParams LARGE_HALL = new ReverbParams(1.0f, 1.0f, 0.316f, 0.871f, 3.5f, 0.92f, 0.45f, 0.025f, 0.85f, 0.035f, 0.994f, 0.0f, 1);
    private static final ReverbParams SMALL_CAVE = new ReverbParams(1.0f, 1.0f, 0.316f, 0.891f, 2.13f, 0.79f, 0.5f, 0.015f, 0.7f, 0.022f, 0.994f, 0.0f, 0);
    private static final ReverbParams CAVE = new ReverbParams(1.0f, 1.0f, 0.316f, 1.0f, 2.91f, 1.3f, 0.5f, 0.015f, 0.706f, 0.022f, 0.994f, 0.0f, 0);
    private static final ReverbParams BIG_CAVE = new ReverbParams(1.0f, 1.0f, 0.316f, 1.0f, 4.32f, 1.5f, 0.5f, 0.03f, 0.8f, 0.039f, 0.994f, 0.0f, 0);
    private static final ReverbParams CATHEDRAL = new ReverbParams(1.0f, 1.0f, 0.316f, 0.891f, 7.24f, 0.87f, 0.5f, 0.056f, 1.26f, 0.024f, 0.994f, 0.0f, 1);

    private ReverbPresets() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static ReverbParams getParams(Reverb reverb) {
        return switch (reverb) {
            default -> throw new MatchException(null, null);
            case Reverb.OUTSIDE -> OUTSIDE;
            case Reverb.FOREST -> FOREST;
            case Reverb.FURNISHED_ROOM -> FURNISHED_ROOM;
            case Reverb.EMPTY_ROOM -> EMPTY_ROOM;
            case Reverb.HALLWAY -> HALLWAY;
            case Reverb.LARGE_HALL -> LARGE_HALL;
            case Reverb.SMALL_CAVE -> SMALL_CAVE;
            case Reverb.CAVE -> CAVE;
            case Reverb.BIG_CAVE -> BIG_CAVE;
            case Reverb.CATHEDRAL -> CATHEDRAL;
        };
    }

    public static class ReverbParams {
        public final float density;
        public final float diffusion;
        public final float gain;
        public final float gainHF;
        public final float decayTime;
        public final float decayHFRatio;
        public final float reflectionsGain;
        public final float reflectionsDelay;
        public final float lateReverbGain;
        public final float lateReverbDelay;
        public final float airAbsorptionGainHF;
        public final float roomRolloffFactor;
        public final int decayHFLimit;

        public ReverbParams(float density, float diffusion, float gain, float gainHF, float decayTime, float decayHFRatio, float reflectionsGain, float reflectionsDelay, float lateReverbGain, float lateReverbDelay, float airAbsorptionGainHF, float roomRolloffFactor, int decayHFLimit) {
            this.density = density;
            this.diffusion = diffusion;
            this.gain = gain;
            this.gainHF = gainHF;
            this.decayTime = decayTime;
            this.decayHFRatio = decayHFRatio;
            this.reflectionsGain = reflectionsGain;
            this.reflectionsDelay = reflectionsDelay;
            this.lateReverbGain = lateReverbGain;
            this.lateReverbDelay = lateReverbDelay;
            this.airAbsorptionGainHF = airAbsorptionGainHF;
            this.roomRolloffFactor = roomRolloffFactor;
            this.decayHFLimit = decayHFLimit;
        }

        public void applyToEffect(int effect) {
            this.applyEffectParam(effect, 1, this.density, "density");
            this.applyEffectParam(effect, 2, this.diffusion, "diffusion");
            this.applyEffectParam(effect, 3, this.gain, "gain");
            this.applyEffectParam(effect, 4, this.gainHF, "gainHF");
            this.applyEffectParam(effect, 5, this.decayTime, "decayTime");
            this.applyEffectParam(effect, 6, this.decayHFRatio, "decayHFRatio");
            this.applyEffectParam(effect, 7, this.reflectionsGain, "reflectionsGain");
            this.applyEffectParam(effect, 8, this.reflectionsDelay, "reflectionsDelay");
            this.applyEffectParam(effect, 9, this.lateReverbGain, "lateReverbGain");
            this.applyEffectParam(effect, 10, this.lateReverbDelay, "lateReverbDelay");
            this.applyEffectParam(effect, 11, this.airAbsorptionGainHF, "airAbsorptionGainHF");
            this.applyEffectParam(effect, 12, this.roomRolloffFactor, "roomRolloffFactor");
            this.applyEffectParamInt(effect, 13, this.decayHFLimit, "decayHFLimit");
        }

        private void applyEffectParam(int effect, int param, float value, String paramName) {
            EXTEfx.alEffectf((int)effect, (int)param, (float)value);
            int error = AL10.alGetError();
            if (error != 0) {
                ModCore.error(String.format("Failed to set reverb parameter %s to %.3f (OpenAL error: 0x%X)", paramName, Float.valueOf(value), error));
            }
        }

        private void applyEffectParamInt(int effect, int param, int value, String paramName) {
            EXTEfx.alEffecti((int)effect, (int)param, (int)value);
            int error = AL10.alGetError();
            if (error != 0) {
                ModCore.error(String.format("Failed to set reverb parameter %s to %d (OpenAL error: 0x%X)", paramName, value, error));
            }
        }
    }
}

