/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound.player;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.WaveformSimilarityBasedOverlapAdd;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import com.wynnvp.wynncraftvp.ModCore;
import com.wynnvp.wynncraftvp.sound.Reverb;
import com.wynnvp.wynncraftvp.sound.player.AudioData;
import com.wynnvp.wynncraftvp.sound.player.CurrentSpeaker;
import com.wynnvp.wynncraftvp.sound.player.ReverbPresets;
import com.wynnvp.wynncraftvp.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;

public class OpenAlPlayer {
    private final ExecutorService executorService;
    private final List<Integer> sourceIDs = Collections.synchronizedList(new ArrayList());
    private final Map<Integer, CurrentSpeaker> currentSpeakers = new ConcurrentHashMap<Integer, CurrentSpeaker>();
    private static final float maxDistance = 20000.0f;
    private final class_315 gameSettings;
    private boolean hasShownVolumeMessage = false;
    private boolean efxSupported = false;
    private final Map<Reverb, Integer> reverbEffects = new EnumMap<Reverb, Integer>(Reverb.class);
    private final Map<Reverb, Integer> reverbSlots = new EnumMap<Reverb, Integer>(Reverb.class);

    public OpenAlPlayer() {
        this.executorService = Executors.newCachedThreadPool();
        this.gameSettings = class_310.method_1551().field_1690;
        this.initializeEFX();
    }

    private void initializeEFX() {
        try {
            long device = ALC10.alcGetCurrentContext();
            if (device == 0L) {
                ModCore.warn("OpenAL context not available, reverb disabled");
                return;
            }
            int testEffect = EXTEfx.alGenEffects();
            if (AL10.alGetError() != 0) {
                ModCore.warn("OpenAL EFX not supported on this system, reverb disabled");
                return;
            }
            EXTEfx.alDeleteEffects((int)testEffect);
            this.efxSupported = true;
            ModCore.info("OpenAL EFX initialized successfully");
            for (Reverb reverb : Reverb.values()) {
                int effect = EXTEfx.alGenEffects();
                if (AL10.alGetError() != 0) {
                    ModCore.error("Failed to create effect for " + reverb.name());
                    continue;
                }
                EXTEfx.alEffecti((int)effect, (int)32769, (int)1);
                if (AL10.alGetError() != 0) {
                    ModCore.error("Failed to set effect type for " + reverb.name());
                    EXTEfx.alDeleteEffects((int)effect);
                    continue;
                }
                ReverbPresets.ReverbParams params = ReverbPresets.getParams(reverb);
                params.applyToEffect(effect);
                int slot = EXTEfx.alGenAuxiliaryEffectSlots();
                if (AL10.alGetError() != 0) {
                    ModCore.error("Failed to create effect slot for " + reverb.name());
                    EXTEfx.alDeleteEffects((int)effect);
                    continue;
                }
                EXTEfx.alAuxiliaryEffectSloti((int)slot, (int)1, (int)effect);
                if (AL10.alGetError() != 0) {
                    ModCore.error("Failed to attach effect to slot for " + reverb.name());
                    EXTEfx.alDeleteEffects((int)effect);
                    EXTEfx.alDeleteAuxiliaryEffectSlots((int)slot);
                    continue;
                }
                this.reverbEffects.put(reverb, effect);
                this.reverbSlots.put(reverb, slot);
            }
            ModCore.info("Created " + this.reverbEffects.size() + " reverb presets");
        }
        catch (Exception e) {
            ModCore.error("Failed to initialize EFX", e);
            this.efxSupported = false;
        }
    }

    private ByteBuffer timeStretch(AudioData audioData, float speed) {
        try {
            ByteBuffer originalBuffer = audioData.byteBuffer;
            byte[] audioBytes = new byte[originalBuffer.remaining()];
            originalBuffer.get(audioBytes);
            originalBuffer.rewind();
            float sampleRate = audioData.audioFormat.getSampleRate();
            AudioFormat javaSoundFormat = new AudioFormat(sampleRate, 16, 1, true, false);
            final ByteArrayOutputStream out = new ByteArrayOutputStream();
            WaveformSimilarityBasedOverlapAdd wsola = new WaveformSimilarityBasedOverlapAdd(WaveformSimilarityBasedOverlapAdd.Parameters.speechDefaults(speed, sampleRate));
            int bufferSize = wsola.getInputBufferSize();
            int overlap = wsola.getOverlap();
            AudioDispatcher dispatcher = AudioDispatcherFactory.fromByteArray(audioBytes, javaSoundFormat, bufferSize, overlap);
            wsola.setDispatcher(dispatcher);
            dispatcher.addAudioProcessor(wsola);
            dispatcher.addAudioProcessor(new AudioProcessor(){

                @Override
                public boolean process(AudioEvent audioEvent) {
                    try {
                        out.write(audioEvent.getByteBuffer());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return true;
                }

                @Override
                public void processingFinished() {
                }
            });
            dispatcher.run();
            byte[] processedAudioBytes = out.toByteArray();
            ByteBuffer processedBuffer = ByteBuffer.allocateDirect(processedAudioBytes.length);
            processedBuffer.put(processedAudioBytes);
            processedBuffer.flip();
            return processedBuffer;
        }
        catch (Exception e) {
            Utils.sendMessage("Failed to apply speed up, using original audio.");
            e.printStackTrace();
            return audioData.byteBuffer;
        }
    }

    public void playAudio(AudioData audioData) {
        this.executorService.execute(() -> {
            if (this.gameSettings.method_1630(class_3419.field_15246) <= 0.0f) {
                if (!this.hasShownVolumeMessage) {
                    Utils.sendMessage("Voice/Speech volume is off. Turn it on in your settings to hear the voices.");
                    this.hasShownVolumeMessage = true;
                }
                return;
            }
            int sourceID = AL10.alGenSources();
            this.sourceIDs.add(sourceID);
            CurrentSpeaker speaker = new CurrentSpeaker(audioData.speakerName, audioData.pos);
            this.currentSpeakers.put(sourceID, speaker);
            int[] buffers = new int[3000];
            AL10.alGenBuffers((int[])buffers);
            if (!ModCore.config.isPlayAllSoundsOnPlayer()) {
                AL11.alDistanceModel((int)53251);
                AL11.alSourcef((int)sourceID, (int)4131, (float)20000.0f);
                AL11.alSourcef((int)sourceID, (int)4128, (float)0.0f);
            } else {
                AL11.alSourcei((int)sourceID, (int)514, (int)1);
                AL11.alSource3f((int)sourceID, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            }
            ByteBuffer monoData = audioData.byteBuffer;
            float speed = ModCore.config.getPlaybackSpeed();
            if (speed != 1.0f) {
                monoData = this.timeStretch(audioData, speed);
                AL11.alBufferData((int)buffers[0], (int)4353, (ByteBuffer)monoData, (int)((int)audioData.audioFormat.getSampleRate()));
                AL11.alSourceQueueBuffers((int)sourceID, (int)buffers[0]);
                this.applyReverb(sourceID, audioData.reverb);
                AL11.alSourcePlay((int)sourceID);
                return;
            }
            if (monoData == null || monoData.remaining() == 0) {
                throw new IllegalArgumentException("Invalid audio data.");
            }
            AL11.alBufferData((int)buffers[0], (int)4353, (ByteBuffer)monoData, (int)((int)audioData.audioFormat.getSampleRate()));
            AL11.alSourceQueueBuffers((int)sourceID, (int)buffers[0]);
            this.applyReverb(sourceID, audioData.reverb);
            AL11.alSourcePlay((int)sourceID);
        });
    }

    private void applyReverb(int sourceID, Reverb reverb) {
        if (!this.efxSupported || reverb == null) {
            return;
        }
        if (ModCore.config != null && !ModCore.config.enableReverb) {
            return;
        }
        Integer slot = this.reverbSlots.get((Object)reverb);
        if (slot == null) {
            return;
        }
        AL11.alSource3i((int)sourceID, (int)131078, (int)slot, (int)0, (int)0);
        if (AL10.alGetError() != 0) {
            ModCore.warn("Failed to apply reverb effect to audio source");
        }
    }

    public void stopAudio() {
        this.executorService.execute(() -> {
            List<Integer> list = this.sourceIDs;
            synchronized (list) {
                for (int sourceID : this.sourceIDs) {
                    AL11.alSourceStop((int)sourceID);
                    AL10.alDeleteSources((int)sourceID);
                }
                this.sourceIDs.clear();
                this.currentSpeakers.clear();
            }
        });
    }

    public void onTick() {
        this.executorService.execute(() -> {
            List<Integer> list = this.sourceIDs;
            synchronized (list) {
                this.sourceIDs.removeIf(sourceID -> {
                    int state = AL11.alGetSourcei((int)sourceID, (int)4112);
                    if (state == 4116) {
                        AL10.alDeleteSources((int)sourceID);
                        this.currentSpeakers.remove(sourceID);
                        return true;
                    }
                    this.setPosition((int)sourceID, this.currentSpeakers.get(sourceID).getUpdatedPosition());
                    return false;
                });
            }
        });
    }

    private void setPosition(int sourceID, Optional<class_243> soundPos) {
        if (ModCore.config.isPlayAllSoundsOnPlayer()) {
            AL11.alSourcei((int)sourceID, (int)514, (int)1);
            AL11.alSource3f((int)sourceID, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
        } else {
            soundPos.ifPresentOrElse(pos -> {
                AL11.alSourcei((int)sourceID, (int)514, (int)0);
                AL11.alSource3f((int)sourceID, (int)4100, (float)((float)pos.field_1352), (float)((float)pos.field_1351), (float)((float)pos.field_1350));
            }, () -> {
                AL11.alSourcei((int)sourceID, (int)514, (int)1);
                AL11.alSource3f((int)sourceID, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            });
        }
        this.updateVolume(sourceID);
    }

    private void updateVolume(int sourceID) {
        float volume = this.gameSettings.method_1630(class_3419.field_15246);
        if (volume <= 0.0f) {
            AL11.alSourceStop((int)sourceID);
        }
        AL10.alSourcef((int)sourceID, (int)4106, (float)volume);
    }
}

