/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound.player;

import com.wynnvp.wynncraftvp.sound.player.AudioData;
import com.wynnvp.wynncraftvp.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import net.minecraft.class_4228;

public class OggDecoder {
    private static final int BUFFER_SIZE = 4096;

    public static short[] byteBufferToShortArray(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        short[] shortArray = new short[byteBuffer.remaining() / 2];
        byteBuffer.asShortBuffer().get(shortArray);
        return shortArray;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<AudioData> getAudioData(Path filePath) {
        if (filePath == null || !filePath.toFile().exists()) {
            System.err.println("File not found: " + String.valueOf(filePath));
            return Optional.empty();
        }
        try (FileInputStream inputStream = new FileInputStream(filePath.toFile());){
            Optional<AudioData> optional;
            try (class_4228 finiteAudioStream = new class_4228((InputStream)inputStream);){
                ByteBuffer byteBuffer = finiteAudioStream.method_59757();
                AudioData audioData = new AudioData(byteBuffer, finiteAudioStream.method_19719());
                optional = Optional.of(audioData);
            }
            return optional;
        }
        catch (IOException e) {
            System.err.println("Error processing audio file: " + String.valueOf(filePath));
            e.printStackTrace();
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<AudioData> getAudioData(ByteBuffer audioBuffer) {
        if (audioBuffer == null || audioBuffer.remaining() == 0) {
            System.err.println("Invalid or empty audio buffer.");
            return Optional.empty();
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(audioBuffer.array());){
            Optional<AudioData> optional;
            try (class_4228 audioStream = new class_4228((InputStream)inputStream);){
                ByteBuffer decodedBuffer = audioStream.method_59757();
                AudioData audioData = new AudioData(decodedBuffer, audioStream.method_19719());
                optional = Optional.of(audioData);
            }
            return optional;
        }
        catch (IOException e) {
            System.err.println("Error processing audio buffer.");
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static AudioData getAudioData(String filePath) {
        AudioData audioData;
        FileInputStream inputStream = new FileInputStream(filePath);
        try {
            AudioData audioData2;
            try (class_4228 finiteAudioStream = new class_4228((InputStream)inputStream);){
                ByteBuffer byteBuffer = finiteAudioStream.method_59757();
                Utils.sendMessage("Format: Channels" + finiteAudioStream.method_19719().getChannels() + " Sample Rate: " + finiteAudioStream.method_19719().getSampleRate() + " Sample Size: " + finiteAudioStream.method_19719().getSampleSizeInBits());
                audioData2 = new AudioData(byteBuffer, finiteAudioStream.method_19719());
            }
            audioData = audioData2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new CompletionException(iOException);
            }
        }
        ((InputStream)inputStream).close();
        return audioData;
    }
}

