/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound.player;

import com.wynnvp.wynncraftvp.ModCore;
import com.wynnvp.wynncraftvp.sound.SoundObject;
import com.wynnvp.wynncraftvp.sound.player.AudioData;
import com.wynnvp.wynncraftvp.sound.player.AutoProgress;
import com.wynnvp.wynncraftvp.sound.player.OggDecoder;
import com.wynnvp.wynncraftvp.sound.player.OpenAlPlayer;
import com.wynnvp.wynncraftvp.utils.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlayer {
    private static final Logger log = LoggerFactory.getLogger(AudioPlayer.class);
    public final OpenAlPlayer openAlPlayer = new OpenAlPlayer();
    public final AutoProgress autoProgress = new AutoProgress();
    public static final String AUDIO_FOLDER = "VOW_AUDIO";
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    private List<String> urls = null;

    private void write(AudioData data) {
        this.openAlPlayer.playAudio(data);
        if (ModCore.config.autoProgress) {
            float speedMultiplier = ModCore.config.getPlaybackSpeed();
            long adjustedDuration = Math.round((float)data.getAudioLengthMillis() / speedMultiplier);
            this.autoProgress.start(adjustedDuration);
        }
    }

    public void playAudioFile(Path path, SoundObject soundObject) {
        Optional<AudioData> audioDataOptional;
        if (soundObject.shouldStopSounds()) {
            this.openAlPlayer.stopAudio();
        }
        if ((audioDataOptional = OggDecoder.getAudioData(path)).isEmpty()) {
            Utils.sendMessage("Failed to load audio file: " + path.toString());
            return;
        }
        AudioData audioData = audioDataOptional.get();
        audioData.setSpeakerAndPos(soundObject.isSoundAtPlayer() ? "" : soundObject.getTrimmedNpcName(), soundObject.getPosition());
        audioData.setReverb(soundObject.getReverb());
        this.write(audioData);
    }

    public void play(SoundObject soundObject) {
        String audioFileName = soundObject.getId();
        Path audioFilePath = Paths.get(AUDIO_FOLDER, audioFileName + ".ogg");
        if (ModCore.config.isUseCustomAudioPath()) {
            this.playFromCustomPath(audioFileName, soundObject);
            return;
        }
        if (ModCore.config.downloadSounds && audioFilePath.toFile().exists()) {
            this.playLocalFile(audioFilePath, soundObject);
            return;
        }
        this.playRemoteAudio(audioFileName, soundObject);
    }

    private void playLocalFile(Path audioFilePath, SoundObject soundObject) {
        this.playAudioFile(audioFilePath, soundObject);
    }

    private void playFromCustomPath(String audioFileName, SoundObject soundObject) {
        String customPath = ModCore.config.getCustomAudioPath();
        boolean isURL = customPath.startsWith("http");
        if (isURL) {
            CompletableFuture.runAsync(() -> {
                ByteBuffer remoteAudioData = null;
                try {
                    remoteAudioData = this.fetchRemoteAudio(customPath + audioFileName + ".ogg");
                }
                catch (IOException | InterruptedException e) {
                    Utils.sendMessage("Failed to fetch remote audio file: " + customPath + audioFileName + ". You are using a custom audio path. Please check your settings if this is an accident.");
                }
                if (remoteAudioData != null) {
                    this.playAudioBuffer(remoteAudioData, soundObject);
                }
            });
            return;
        }
        Path customAudioPath = Paths.get(customPath, audioFileName + ".ogg");
        if (customAudioPath.toFile().exists()) {
            this.playLocalFile(customAudioPath, soundObject);
        } else {
            Utils.sendMessage("Failed to load custom audio file: " + String.valueOf(customAudioPath) + ". Please check your settings. You are using a custom audio path.");
        }
    }

    private void playRemoteAudio(String audioFileName, SoundObject soundObject) {
        CompletableFuture.runAsync(() -> {
            List<String> allRemoteUrls = this.getRemoteUrls();
            ByteBuffer remoteAudioData = null;
            for (String url : allRemoteUrls) {
                try {
                    remoteAudioData = this.fetchRemoteAudio(url + audioFileName + ".ogg");
                    break;
                }
                catch (IOException | InterruptedException e) {
                    log.info("[Voices of Wynn] Failed to fetch remote audio file: {}{}.", (Object)url, (Object)audioFileName);
                }
            }
            if (remoteAudioData != null) {
                this.playAudioBuffer(remoteAudioData, soundObject);
            } else {
                Utils.sendMessage("Failed to fetch remote audio file for " + audioFileName + ". If this keeps happening go into your settings, enable the download sounds option and restart your game.");
            }
        });
    }

    private ByteBuffer fetchRemoteAudio(String urlString) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(urlString)).timeout(Duration.ofSeconds(3L)).GET().build();
        HttpResponse<byte[]> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        if (response.statusCode() == 200) {
            return ByteBuffer.wrap(response.body());
        }
        throw new IOException("Failed to fetch audio: " + response.statusCode());
    }

    private List<String> getRemoteUrls() {
        if (this.urls != null) {
            return this.urls;
        }
        this.urls = new ArrayList<String>(ModCore.config.urls);
        String fastestServer = ModCore.config.azureBlobLink;
        this.urls.remove(fastestServer);
        this.urls.addFirst(fastestServer);
        return this.urls;
    }

    public void playAudioBuffer(ByteBuffer audioData, SoundObject soundObject) {
        Optional<AudioData> audioDataOptional;
        if (soundObject.shouldStopSounds()) {
            this.openAlPlayer.stopAudio();
        }
        if ((audioDataOptional = OggDecoder.getAudioData(audioData)).isEmpty()) {
            Utils.sendMessage("Failed to decode remote audio data.");
            return;
        }
        AudioData audio = audioDataOptional.get();
        audio.setSpeakerAndPos(soundObject.isSoundAtPlayer() ? "" : soundObject.getTrimmedNpcName(), soundObject.getPosition());
        audio.setReverb(soundObject.getReverb());
        this.write(audio);
    }
}

