/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound.line;

import com.wynnvp.wynncraftvp.ModCore;
import com.wynnvp.wynncraftvp.sound.line.LineData;
import com.wynnvp.wynncraftvp.utils.Utils;
import com.wynnvp.wynncraftvp.utils.VersionChecker;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class LineReporter {
    private final Queue<String> reportedLines = new LinkedList<String>();

    public void MissingLine(LineData lineData) {
        if (!(ModCore.config.isReportMissingLines() && ModCore.inLiveWynnServer && lineData.isNPCSentLine() && VersionChecker.isOnUpToDateVersion)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            if (this.reportedLines.contains(lineData.getRealLine())) {
                return;
            }
            this.reportedLines.add(lineData.getRealLine());
            if (this.reportedLines.size() > 20) {
                this.reportedLines.remove();
            }
            try {
                this.reportUnvoicedLine(lineData);
                System.out.println("Unvoiced line report has been sent to our servers. This contained: " + lineData.getRealLine());
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("A report of unvoiced line couldn't be sent. Error code should be right above this message.");
            }
        });
    }

    private void reportUnvoicedLine(LineData lineData) throws IOException {
        String npcName = lineData.getNPCName();
        String name = ModCore.config.isAnonymous() ? "anonymous" : class_310.method_1551().field_1724.method_5477().toString();
        String fullLine = lineData.getRealLine();
        class_746 p = class_310.method_1551().field_1724;
        int CoordX = (int)p.method_73189().field_1352;
        int CoordY = (int)p.method_73189().field_1351;
        int CoordZ = (int)p.method_73189().field_1350;
        URL urlObj = new URL("http://voicesofwynn.com/api/unvoiced-line-report/new");
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", "VoicesOfWynnModClient");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        fullLine = Utils.HTTPEncode(fullLine);
        npcName = Utils.HTTPEncode(npcName);
        name = Utils.HTTPEncode(name);
        String urlPostParameters = "npc=" + npcName + "&player=" + name + "&full=" + fullLine + "&x=" + CoordX + "&y=" + CoordY + "&z=" + CoordZ + "&apiKey=" + ModCore.config.getWord();
        outputStream.writeBytes(urlPostParameters);
        outputStream.flush();
        outputStream.close();
        Integer responseCode = connection.getResponseCode();
        System.out.println("HTTP response Code : " + responseCode);
    }
}

