/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound.downloader;

import com.wynnvp.wynncraftvp.sound.downloader.DownloadProgressToast;
import com.wynnvp.wynncraftvp.sound.downloader.DownloadTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_310;

public class DownloadQueue {
    private PriorityBlockingQueue<DownloadTask> queue;
    private final String audioFolder;
    private final String baseUrl;
    private final ExecutorService executor;
    private final int threadCount = 10;
    private volatile boolean running = false;
    private Runnable onQueueEmpty;
    private volatile boolean queueEmptyNotified = false;
    private final DownloadProgressToast progressToast;

    public DownloadQueue(String audioFolder, String baseUrl, int downloadCount) {
        this.audioFolder = audioFolder;
        this.baseUrl = baseUrl;
        this.queue = new PriorityBlockingQueue();
        this.executor = Executors.newFixedThreadPool(10);
        this.progressToast = new DownloadProgressToast(class_310.method_1551(), "Downloading Voices of Wynn audio", downloadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        DownloadQueue downloadQueue = this;
        synchronized (downloadQueue) {
            if (!this.running) {
                this.running = true;
                this.queueEmptyNotified = false;
                for (int i = 0; i < 10; ++i) {
                    this.executor.submit(this::worker);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        DownloadQueue downloadQueue = this;
        synchronized (downloadQueue) {
            this.running = false;
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void setOnQueueEmpty(Runnable onQueueEmpty) {
        this.onQueueEmpty = onQueueEmpty;
    }

    public void initializeQueue(List<DownloadTask> tasks) {
        this.queue = new PriorityBlockingQueue<DownloadTask>(tasks);
    }

    private void worker() {
        while (this.running) {
            try {
                DownloadTask task = this.queue.poll(1L, TimeUnit.SECONDS);
                if (task == null) {
                    this.checkQueueEmpty();
                    continue;
                }
                String fileName = this.sanitizeFileName(task.getAudioName()) + ".ogg";
                File localFile = new File(this.audioFolder, fileName);
                try {
                    this.downloadFile(this.baseUrl + fileName, localFile);
                    this.progressToast.increaseCount();
                }
                catch (IOException e) {
                    System.err.println("Failed to download " + task.getAudioName() + ": " + e.getMessage());
                    this.progressToast.addFailed();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQueueEmpty() {
        if (this.queue.isEmpty() && this.onQueueEmpty != null && !this.queueEmptyNotified) {
            DownloadQueue downloadQueue = this;
            synchronized (downloadQueue) {
                if (this.queue.isEmpty() && !this.queueEmptyNotified) {
                    this.queueEmptyNotified = true;
                    this.onQueueEmpty.run();
                    this.progressToast.requestFinished();
                    this.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String fileURL, File destination) throws IOException {
        block17: {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)new URL(fileURL).openConnection();
                connection.setRequestMethod("GET");
                connection.connect();
                if (connection.getResponseCode() == 200) {
                    try (InputStream inputStream = connection.getInputStream();
                         FileOutputStream outputStream = new FileOutputStream(destination);){
                        int bytesRead;
                        byte[] buffer = new byte[8192];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        break block17;
                    }
                }
                throw new IOException("Failed to download file: " + fileURL);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    private String sanitizeFileName(String fileName) {
        return fileName.replaceAll("[^a-zA-Z0-9._-]", "_");
    }
}

