/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound.downloader;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wynnvp.wynncraftvp.ModCore;
import com.wynnvp.wynncraftvp.sound.downloader.AudioMetadata;
import com.wynnvp.wynncraftvp.sound.downloader.DownloadQueue;
import com.wynnvp.wynncraftvp.sound.downloader.DownloadTask;
import com.wynnvp.wynncraftvp.sound.downloader.ToastManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioDownloader {
    private final String audioDir;
    private static final String BASE_URL = "https://cdn.jsdelivr.net/gh/Team-VoW/WynncraftVoiceProject@main/sounds/";
    private static final String AUDIO_MANIFEST = "https://cdn.jsdelivr.net/gh/Team-VoW/WynncraftVoiceProject@main/audio_manifest.json";
    private final HashMap<String, AudioMetadata> metadataMap = new HashMap();
    private HashMap<String, AudioMetadata> remoteMetadata;
    private File audioFolder;
    private final int maxRuns = 2;
    private int currentRun = 0;
    private final int minSizeForConfirmation = 50;
    private final Gson gson;
    private long downloadSize;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VoW Audio Downloader");
    private boolean hasRan = false;

    public static void main(String[] args) {
        AudioDownloader audioDownloader = new AudioDownloader("VOW_AUDIO");
        audioDownloader.checkToDownload();
    }

    public AudioDownloader(String audioFolder) {
        this.audioDir = audioFolder;
        this.gson = new Gson();
    }

    public void checkIfHasNot() {
        if (this.hasRan || !ModCore.config.downloadSounds) {
            return;
        }
        this.hasRan = true;
        this.checkToDownload();
    }

    public void checkToDownload() {
        this.audioFolder = new File(this.audioDir);
        if (!this.audioFolder.exists() && !this.audioFolder.mkdirs()) {
            LOGGER.error("Failed to create audio folder: " + this.audioFolder.getAbsolutePath());
            return;
        }
        CompletableFuture.runAsync(this::processAudioManifest);
    }

    private void processAudioManifest() {
        try {
            this.remoteMetadata = this.fetchAudioManifest();
            if (this.remoteMetadata == null) {
                LOGGER.error("Failed to fetch audio manifest on first attempt. Retrying in 20 seconds...");
                Thread.sleep(10000L);
                this.remoteMetadata = this.fetchAudioManifest();
                if (this.remoteMetadata == null) {
                    LOGGER.error("Failed to fetch audio manifest after retry.");
                    return;
                }
            }
            this.populateLocalMetadata();
            List<String> toDownload = this.getToDownload();
            if (toDownload.isEmpty()) {
                LOGGER.info("No files to download. Up to date");
                return;
            }
            LOGGER.info("Downloading " + toDownload.size() + " files");
            long downloadSizeInMB = this.downloadSize / 1024L / 1024L;
            LOGGER.info("Total download size: " + downloadSizeInMB + " MB");
            if (downloadSizeInMB < 50L) {
                this.StartDownloadQueue(toDownload);
                return;
            }
            ToastManager.getInstance().displayTimedToast(() -> this.StartDownloadQueue(toDownload), 10, "Voices of Wynn Download. Size: " + downloadSizeInMB + " MB", "Press N to cancel.");
        }
        catch (Exception e) {
            LOGGER.error("Error in audio manifest processing");
            e.printStackTrace();
        }
    }

    private void StartDownloadQueue(List<String> toDownload) {
        DownloadQueue downloadQueue = new DownloadQueue(this.audioDir, BASE_URL, toDownload.size());
        ArrayList<DownloadTask> tasks = new ArrayList<DownloadTask>(toDownload.stream().map(id -> new DownloadTask((String)id, 1)).toList());
        downloadQueue.setOnQueueEmpty(() -> {
            LOGGER.info("Download complete");
            this.cleanUpUnusedFiles();
            this.populateLocalMetadata();
            List<String> failedToDownload = this.getToDownload();
            if (failedToDownload.isEmpty()) {
                LOGGER.info("All files downloaded successfully");
                ToastManager.getInstance().displayToast((class_2561)class_2561.method_43470((String)"Voices of Wynn audio downloaded successfully"), (class_2561)class_2561.method_43470((String)"All files downloaded successfully"));
                return;
            }
            LOGGER.info("Failed to download " + failedToDownload.size() + "(" + failedToDownload.size() * 100 / toDownload.size() + "%");
            failedToDownload.forEach(fail -> LOGGER.info("Failed: " + fail));
            ++this.currentRun;
            if (this.currentRun >= 2) {
                LOGGER.info("Max runs reached, stopping download process");
                ToastManager.getInstance().displayToast((class_2561)class_2561.method_43470((String)("Failed to download " + failedToDownload.size() + " files")), (class_2561)class_2561.method_43470((String)"Restart the game to try downloading again"));
                return;
            }
            ToastManager.getInstance().displayToast((class_2561)class_2561.method_43470((String)("Failed to download " + failedToDownload.size() + " files")), (class_2561)class_2561.method_43470((String)"Will try downloading these files again"));
            CompletableFuture.runAsync(this::processAudioManifest);
        });
        downloadQueue.initializeQueue(tasks);
        downloadQueue.start();
    }

    private List<String> getToDownload() {
        this.downloadSize = 0L;
        return new ArrayList<String>(this.remoteMetadata.entrySet().stream().filter(entry -> {
            boolean shouldDownload;
            String id = (String)entry.getKey();
            long size = ((AudioMetadata)entry.getValue()).size();
            AudioMetadata audioMetadata = (AudioMetadata)entry.getValue();
            AudioMetadata localMetadata = this.metadataMap.get(id);
            boolean bl = shouldDownload = localMetadata == null || !localMetadata.hash().equals(audioMetadata.hash());
            if (shouldDownload) {
                this.downloadSize += size;
            }
            return shouldDownload;
        }).map(Map.Entry::getKey).toList());
    }

    private void populateLocalMetadata() {
        this.audioFolder = new File(this.audioDir);
        if (!this.audioFolder.exists() && !this.audioFolder.mkdirs()) {
            LOGGER.error("Failed to create audio folder: " + this.audioFolder.getAbsolutePath());
            return;
        }
        this.metadataMap.clear();
        File[] localFiles = this.audioFolder.listFiles((dir, name) -> name.endsWith(".ogg"));
        if (localFiles != null) {
            for (File localFile : localFiles) {
                String fileName = localFile.getName().replace(".ogg", "");
                try {
                    String hash = this.computeFileHash(localFile);
                    this.metadataMap.put(fileName, new AudioMetadata(localFile.length(), hash));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to compute hash for file: " + localFile.getName());
                    e.printStackTrace();
                }
            }
            LOGGER.info("Populated metadata map with " + this.metadataMap.size() + " files");
        }
    }

    private HashMap<String, AudioMetadata> fetchAudioManifest() throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(AUDIO_MANIFEST).openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            if (connection.getResponseCode() == 200) {
                try (InputStream inputStream = connection.getInputStream();){
                    HashMap hashMap;
                    try (InputStreamReader reader = new InputStreamReader(inputStream);){
                        hashMap = (HashMap)this.gson.fromJson((Reader)reader, new TypeToken<HashMap<String, AudioMetadata>>(this){}.getType());
                    }
                    return hashMap;
                }
            }
            throw new IOException("Failed to fetch audio manifest: https://cdn.jsdelivr.net/gh/Team-VoW/WynncraftVoiceProject@main/audio_manifest.json");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String computeFileHash(File file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)fis).read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private void cleanUpUnusedFiles() {
        if (this.remoteMetadata == null) {
            LOGGER.error("Remote metadata is null, cannot clean up unused files");
            return;
        }
        File audioFolder = new File(this.audioDir);
        File[] localFiles = audioFolder.listFiles((dir, name) -> name.endsWith(".ogg"));
        if (localFiles != null) {
            for (File localFile : localFiles) {
                String fileName = localFile.getName().replace(".ogg", "");
                if (this.remoteMetadata.containsKey(fileName)) continue;
                LOGGER.info("Deleting unused file: " + localFile.getName());
                if (localFile.delete()) continue;
                LOGGER.error("Failed to delete file: " + localFile.getName());
            }
        }
    }
}

