/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import com.wynnvp.wynncraftvp.ModCore;
import com.wynnvp.wynncraftvp.sound.DialogueData;
import com.wynnvp.wynncraftvp.sound.Reverb;
import com.wynnvp.wynncraftvp.sound.ReverbDeserializer;
import com.wynnvp.wynncraftvp.sound.SoundObject;
import com.wynnvp.wynncraftvp.sound.line.LineData;
import com.wynnvp.wynncraftvp.utils.LineFormatter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_243;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundsHandler {
    private static final String JSON_FILE = "sounds.json";
    private final HashMap<String, SoundObject> sounds = new HashMap();
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Reverb.class, (Object)new ReverbDeserializer()).create();
    private static final Logger LOGGER = LogManager.getLogger(SoundsHandler.class);

    public SoundsHandler() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            try {
                if (this.shouldUpdateJson()) {
                    LOGGER.info("[Voices of Wynn] Updating JSON audio file.");
                    this.downloadJson();
                }
                this.loadSoundsFromJson(this.getJsonStream());
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof MalformedJsonException) {
                    LOGGER.error("[Voices of Wynn] Detected corrupted JSON file, attempting to fix", (Throwable)e);
                    this.handleCorruptedJsonFile();
                }
                LOGGER.error("[Voices of Wynn] Failed to initialize sounds", (Throwable)e);
            }
        });
    }

    private void handleCorruptedJsonFile() {
        try {
            Files.deleteIfExists(Paths.get(JSON_FILE, new String[0]));
            LOGGER.info("[Voices of Wynn] Deleted corrupted sounds.json file");
            this.downloadJson();
            this.loadSoundsFromJson(this.getJsonStream());
            LOGGER.info("[Voices of Wynn] Successfully recovered from corrupted JSON file");
        }
        catch (Exception e) {
            LOGGER.error("[Voices of Wynn] Failed to recover from corrupted JSON file", (Throwable)e);
            try {
                InputStream bundledStream = this.getClass().getClassLoader().getResourceAsStream(JSON_FILE);
                if (bundledStream != null) {
                    this.loadSoundsFromJson(bundledStream);
                    LOGGER.info("[Voices of Wynn] Successfully loaded bundled sounds.json as fallback");
                }
            }
            catch (Exception ex) {
                LOGGER.error("[Voices of Wynn] All recovery attempts failed", (Throwable)ex);
            }
        }
    }

    public HashMap<String, SoundObject> getSounds() {
        return this.sounds;
    }

    private void loadSoundsFromJson(InputStream inputStream) {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            Type dialogueListType = new TypeToken<List<DialogueData>>(this){}.getType();
            List dialogues = (List)this.gson.fromJson((Reader)reader, dialogueListType);
            for (DialogueData dialogue : dialogues) {
                String message = dialogue.getDialogueLine();
                String fileName = dialogue.getFile();
                boolean movingSound = dialogue.isOnPlayer();
                class_243 position = dialogue.getPos();
                int fallOff = dialogue.getFallOff();
                String npcName = dialogue.getNpc();
                Reverb environment = dialogue.getReverb();
                boolean stopSounds = dialogue.shouldStopSounds();
                LineData lineData = LineFormatter.formatToLineData(message);
                message = lineData.getSoundLine();
                this.sounds.put(message, new SoundObject(lineData.getNPCName(), fileName, movingSound, position, fallOff, stopSounds, environment));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load JSON file", e);
        }
    }

    private boolean shouldUpdateJson() {
        if (ModCore.config.isUseCustomSoundsJson()) {
            return false;
        }
        if (!Files.exists(Paths.get(JSON_FILE, new String[0]), new LinkOption[0])) {
            return true;
        }
        try {
            String lastModifiedStored = ModCore.config.lastsSoundsUpdateHeader;
            String lastModifiedNew = this.fetchLastModifiedHeader();
            if (lastModifiedNew == null || !lastModifiedNew.equals(lastModifiedStored)) {
                ModCore.config.lastsSoundsUpdateHeader = lastModifiedNew;
                ModCore.config.save();
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("[Voices of Wynn] Failed to download determine if it should update the Json", (Throwable)e);
        }
        return false;
    }

    private String fetchLastModifiedHeader() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(ModCore.config.getRemoteJsonLink()).openConnection();
            connection.setRequestMethod("HEAD");
            if (connection.getResponseCode() == 200) {
                return connection.getHeaderField("Last-Modified");
            }
        }
        catch (Exception e) {
            LOGGER.error("[Voices of Wynn] Failed to fetch lastModifiedHeader", (Throwable)e);
        }
        return null;
    }

    private void downloadJson() {
        block15: {
            try {
                LOGGER.info("Downloading updated sounds.json");
                HttpURLConnection connection = (HttpURLConnection)new URL(ModCore.config.getRemoteJsonLink()).openConnection();
                connection.setRequestMethod("GET");
                if (connection.getResponseCode() == 200) {
                    try (InputStream inputStream = connection.getInputStream();
                         FileOutputStream outputStream = new FileOutputStream(JSON_FILE);){
                        int bytesRead;
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                        }
                        break block15;
                    }
                }
                LOGGER.info("[Voices of Wynn] Failed to download JSON file. Response code: {}", (Object)connection.getResponseCode());
            }
            catch (IOException e) {
                LOGGER.error("[Voices of Wynn] Failed to download sounds.json file", (Throwable)e);
            }
        }
    }

    private InputStream getJsonStream() {
        if (ModCore.config.isUseCustomSoundsJson()) {
            String customPath = ModCore.config.getCustomSoundsJsonPath();
            if (customPath != null && !customPath.isEmpty() && Files.exists(Paths.get(customPath, new String[0]), new LinkOption[0])) {
                try {
                    LOGGER.info("[Voices of Wynn] Using custom sounds.json file from: {}", (Object)customPath);
                    return new FileInputStream(customPath);
                }
                catch (IOException e) {
                    LOGGER.error("[Voices of Wynn] Failed to load custom sounds.json from: {}", (Object)customPath, (Object)e);
                    LOGGER.info("[Voices of Wynn] Falling back to default sounds.json");
                }
            } else {
                LOGGER.warn("[Voices of Wynn] Custom sounds.json enabled but path is invalid or file doesn't exist: {}", (Object)customPath);
                LOGGER.info("[Voices of Wynn] Falling back to default sounds.json");
            }
        }
        if (Files.exists(Paths.get(JSON_FILE, new String[0]), new LinkOption[0])) {
            try {
                LOGGER.info("[Voices of Wynn] Using cached sounds.json file");
                return new FileInputStream(JSON_FILE);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to open local JSON file", e);
            }
        }
        LOGGER.info("[Voices of Wynn] Using bundled sounds.json file");
        InputStream bundledStream = this.getClass().getClassLoader().getResourceAsStream(JSON_FILE);
        if (bundledStream != null) {
            return bundledStream;
        }
        LOGGER.error("[Voices of Wynn] COULD NOT FIND BUNDLED SOUNDS.JSON FILE");
        throw new IllegalStateException("No valid JSON file found!");
    }

    public Optional<SoundObject> get(String message) {
        return Optional.ofNullable(this.sounds.get(message));
    }
}

