/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound;

import com.wynnvp.wynncraftvp.ModCore;
import com.wynnvp.wynncraftvp.logging.VowLogger;
import com.wynnvp.wynncraftvp.sound.SoundObject;
import com.wynnvp.wynncraftvp.sound.SoundsHandler;
import com.wynnvp.wynncraftvp.sound.line.LineData;
import com.wynnvp.wynncraftvp.sound.line.LineReporter;
import com.wynnvp.wynncraftvp.utils.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_243;

public class SoundPlayer {
    private final LineReporter lineReporter = new LineReporter();

    public void playSound(LineData lineData) {
        if (ModCore.config.isLogPlayingInformation()) {
            VowLogger.logLine("[Attempting to play] " + lineData.getRealLine().trim() + " HTTP encoded:" + Utils.HTTPEncode(lineData.getRealLine().trim()), "Info");
        }
        String line = lineData.getSoundLine();
        SoundsHandler soundsHandler = ModCore.instance.soundsHandler;
        if (!this.canPlaySound(soundsHandler, lineData)) {
            return;
        }
        if (!ModCore.config.isOnlyLogNotPlayingLines() && ModCore.config.isLogDialogueLines()) {
            VowLogger.logLine(lineData.getRealLine() + " [PLAYED]");
        }
        soundsHandler.get(line).ifPresentOrElse(this::PlaySoundObject, () -> {
            if (ModCore.config.isLogPlayingInformation()) {
                VowLogger.logLine("Could not play sound: " + line, "Info");
            }
        });
    }

    private boolean canPlaySound(SoundsHandler soundsHandler, LineData lineData) {
        String line = lineData.getSoundLine();
        if (soundsHandler.get(line).isEmpty()) {
            if (ModCore.config.isLogDialogueLines() && lineData.isNPCSentLine()) {
                VowLogger.logLine(lineData.getRealLine());
            }
            this.lineReporter.MissingLine(lineData);
            return false;
        }
        return true;
    }

    private void PlaySoundObject(SoundObject sound) {
        if (ModCore.instance.audioPlayer == null) {
            Utils.sendMessage("ERROR! SOUND ENGINE WAS NOT INITIALIZED! PLEASE MAKE A REPORT");
            return;
        }
        if (sound.getId() == null) {
            return;
        }
        ModCore.instance.audioPlayer.play(sound);
    }

    private boolean isOutsideReach(SoundObject soundObject, class_1657 player, class_243 npcPosition) {
        int soundObjectFallOff = soundObject.getFallOff();
        int squaredFalloff = soundObjectFallOff == 0 ? ModCore.config.getBlockCutOff() * ModCore.config.getBlockCutOff() : soundObjectFallOff * soundObjectFallOff;
        return player.method_73189().method_1025(npcPosition) >= (double)squaredFalloff;
    }
}

