/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.wynnvp.wynncraftvp.sound.Reverb;
import java.lang.reflect.Type;

public class ReverbDeserializer
implements JsonDeserializer<Reverb> {
    public Reverb deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return Reverb.OUTSIDE;
        }
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            int id = json.getAsInt();
            Reverb reverb = Reverb.fromId(id);
            if (reverb != null) {
                return reverb;
            }
            throw new JsonParseException("Invalid reverb ID: " + id + ". Must be between 0 and 9.");
        }
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            String name = json.getAsString();
            try {
                return Reverb.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Invalid reverb name: " + name, (Throwable)e);
            }
        }
        throw new JsonParseException("Reverb must be an integer (0-9) or string enum name");
    }
}

