/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.wynnvp.wynncraftvp.sound.DialogueData;
import com.wynnvp.wynncraftvp.sound.line.LineData;
import com.wynnvp.wynncraftvp.utils.LineFormatter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;

public class JsonConverter {
    private final List<DialogueData> DialogueDataList = new ArrayList<DialogueData>();

    public static void main(String[] args) {
        JsonConverter yamlConverter = new JsonConverter();
        yamlConverter.saveToJson("sounds.json");
    }

    public void addSound(String message, String id, boolean movingSound) {
        this.addSound(message, id, movingSound, null);
    }

    public void addSound(String message, String id, boolean movingSound, class_243 position) {
        this.addSound(message, id, movingSound, position, 0);
    }

    public void addSound(String message, String id, boolean movingSound, int fallOff) {
        this.addSound(message, id, movingSound, null, fallOff);
    }

    public void addSound(String message, String id, boolean movingSound, class_243 position, int fallOff) {
        LineData lineData = LineFormatter.formatToLineData(message);
        String npcName = lineData.getNPCName();
        DialogueData DialogueData2 = new DialogueData();
        DialogueData2.setDialogueLine(message);
        DialogueData2.setFile(id);
        DialogueData2.setOnPlayer(movingSound);
        DialogueData2.setPos(position);
        if (fallOff != 0) {
            DialogueData2.setFallOff(fallOff);
        }
        DialogueData2.setNpc(npcName);
        DialogueData2.setReverb(null);
        this.DialogueDataList.add(DialogueData2);
    }

    public void saveToJson(String jsonFilePath) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        try (FileWriter writer = new FileWriter(jsonFilePath);){
            gson.toJson(this.DialogueDataList, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

