/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.sound;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class BlobLatencyChecker {
    private final List<String> storageUrls;
    private final ExecutorService executor;
    private static final int SAMPLES_PER_ENDPOINT = 5;
    private static final int WARMUP_REQUESTS = 2;

    public BlobLatencyChecker(List<String> urls) {
        this.storageUrls = urls;
        this.executor = Executors.newFixedThreadPool(urls.size());
    }

    public CompletableFuture<String> findFastestEndpointAsync() {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, List> allLatencies = new HashMap<String, List>();
            ArrayList<CompletableFuture<Map.Entry>> futures = new ArrayList<CompletableFuture<Map.Entry>>();
            for (String string : this.storageUrls) {
                CompletableFuture<Map.Entry> future = CompletableFuture.supplyAsync(() -> {
                    List<Long> latencies = this.checkLatencyMultipleTimes(url);
                    return Map.entry(url, latencies);
                }, this.executor);
                futures.add(future);
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            for (CompletableFuture completableFuture : futures) {
                Map.Entry result = (Map.Entry)completableFuture.join();
                allLatencies.put((String)result.getKey(), (List)result.getValue());
            }
            String fastestUrl = allLatencies.entrySet().stream().min(Map.Entry.comparingByValue((list1, list2) -> {
                double avg1 = list1.stream().mapToDouble(Long::doubleValue).average().orElse(Double.MAX_VALUE);
                double avg2 = list2.stream().mapToDouble(Long::doubleValue).average().orElse(Double.MAX_VALUE);
                return Double.compare(avg1, avg2);
            })).map(Map.Entry::getKey).orElse(this.storageUrls.get(0));
            return fastestUrl;
        }, this.executor);
    }

    private List<Long> checkLatencyMultipleTimes(String baseUrl) {
        int i;
        ArrayList<Long> latencies = new ArrayList<Long>();
        for (i = 0; i < 2; ++i) {
            this.checkLatency(baseUrl);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        for (i = 0; i < 5; ++i) {
            long latency = this.checkLatency(baseUrl);
            if (latency != Long.MAX_VALUE) {
                latencies.add(latency);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return latencies;
    }

    private long checkLatency(String baseUrl) {
        try {
            URL url = new URL(baseUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            long startTime = System.nanoTime();
            connection.connect();
            int responseCode = connection.getResponseCode();
            long latency = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            connection.disconnect();
            if (responseCode >= 200 && responseCode < 500) {
                return latency;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Long.MAX_VALUE;
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }
}

