/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.npc;

import com.wynnvp.wynncraftvp.ModCore;
import com.wynnvp.wynncraftvp.npc.CachedEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8113;

public class NPCHandler {
    public static CachedEntity findEntity(String rawName) {
        CachedEntity c = NPCHandler.findNPC(rawName = NPCHandler.getName(rawName));
        if (!NPCHandler.isCachedValid(c)) {
            return null;
        }
        return c;
    }

    private static CachedEntity findNPC(String rawName) {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        class_1297 entity = NPCHandler.findClosestTextDisplay(rawName, (class_1657)player);
        if (entity == null) {
            return new CachedEntity();
        }
        class_1297 childEntity = NPCHandler.getHead(entity);
        if (childEntity == null) {
            childEntity = entity;
        }
        CachedEntity cachedEntity = new CachedEntity(entity, childEntity);
        return cachedEntity;
    }

    private static class_1297 getHead(class_1297 entity) {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        double closestSquaredXYDistance = 1.3;
        class_1297 childEntity = null;
        class_243 npcEyePos = entity.method_33571().method_1031(0.0, -0.2, 0.0);
        for (class_1297 entityInWorld : class_310.method_1551().field_1687.method_18112()) {
            double xzBlockDistance = NPCHandler.squaredXZDistance(entityInWorld.method_33571(), npcEyePos);
            if (closestSquaredXYDistance < xzBlockDistance || entityInWorld.method_33571().field_1351 > npcEyePos.field_1351 + 0.4) continue;
            if (!entityInWorld.method_5767()) {
                closestSquaredXYDistance = xzBlockDistance;
                childEntity = entityInWorld;
                continue;
            }
            if (!NPCHandler.isArmourStand(entityInWorld)) continue;
            childEntity = entityInWorld;
            break;
        }
        return childEntity;
    }

    private static double squaredXZDistance(class_243 first, class_243 second) {
        double d = first.field_1352 - second.field_1352;
        double f = first.field_1350 - second.field_1350;
        return d * d + f * f;
    }

    public static boolean isArmourStand(class_1297 entity) {
        return entity instanceof class_1531;
    }

    public static class_1297 findClosestTextDisplay(String rawName, class_1657 player) {
        double closestDistance = Double.MAX_VALUE;
        class_1297 closestPosition = null;
        class_243 playerEyePos = player.method_33571();
        for (class_1297 entity : class_310.method_1551().field_1687.method_18467(class_8113.class_8123.class, new class_238(player.method_33571().field_1352 - 100.0, player.method_33571().field_1351 - 100.0, player.method_33571().field_1350 - 100.0, player.method_33571().field_1352 + 100.0, player.method_33571().field_1351 + 100.0, player.method_33571().field_1350 + 100.0))) {
            double distance;
            class_2561 text;
            class_8113.class_8123 textDisplay;
            if (!(entity instanceof class_8113.class_8123) || (textDisplay = (class_8113.class_8123)entity).method_49784() == null || !NPCHandler.getName((text = textDisplay.method_49784().comp_1334()).getString()).contains(rawName) || !((distance = textDisplay.method_73189().method_1025(playerEyePos)) < closestDistance)) continue;
            closestDistance = distance;
            closestPosition = entity;
        }
        return closestPosition;
    }

    private static String getName(class_1297 entity) {
        return NPCHandler.getName(entity.method_5476().getString());
    }

    private static String getName(String name) {
        return name.replaceAll("\u00a7.", "").toLowerCase().replaceAll("[^a-z?\\d]", "");
    }

    public static boolean isCachedValid(CachedEntity c) {
        if (c == null || c.child == null || c.name == null) {
            return false;
        }
        if (!c.name.method_5805()) {
            return false;
        }
        if (!c.child.method_5805()) {
            return false;
        }
        if (c.child.method_5767() && !c.isArmourStand) {
            return false;
        }
        if (c.name.method_33571().method_1022(class_310.method_1551().field_1724.method_33571()) > 200.0) {
            return false;
        }
        return !(Math.abs((double)c.name.method_5739(c.child) - c.distance) > ModCore.config.getNpcFinderThingMaxDistanceChangeBeforeCacheInvalid());
    }
}

