/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.managers.sound.dialogue.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.wynnvp.wynncraftvp.managers.sound.dialogue.ContextDialogueHolder;
import com.wynnvp.wynncraftvp.managers.sound.dialogue.DialogueContextHolder;
import com.wynnvp.wynncraftvp.managers.sound.dialogue.DialogueData;
import com.wynnvp.wynncraftvp.managers.sound.dialogue.DialogueHolder;
import com.wynnvp.wynncraftvp.managers.sound.dialogue.DialogueInfo;
import com.wynnvp.wynncraftvp.managers.sound.dialogue.DialogueLineInfo;
import com.wynnvp.wynncraftvp.managers.sound.dialogue.DialogueSoundSettings;
import com.wynnvp.wynncraftvp.managers.sound.dialogue.ResolvedDialogueSoundSettings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.joml.Vector3f;

public class DialogueHolderDeserializer
implements JsonDeserializer<DialogueHolder> {
    public DialogueHolder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonDialogueHolder jsonHolder = (JsonDialogueHolder)context.deserialize(json, JsonDialogueHolder.class);
        TreeMap<String, DialogueContextHolder> content = new TreeMap<String, DialogueContextHolder>();
        for (Map.Entry<String, JsonDialogueContextHolder> contentEntry : jsonHolder.content.entrySet()) {
            JsonDialogueContextHolder jsonContextHolder = contentEntry.getValue();
            LinkedHashMap<String, ContextDialogueHolder> contexts = new LinkedHashMap<String, ContextDialogueHolder>();
            for (Map.Entry<String, JsonContextDialogueHolder> contextEntry : jsonContextHolder.contexts.entrySet()) {
                JsonContextDialogueHolder jsonContextDialogueHolder = contextEntry.getValue();
                ArrayList<JsonDialogue> dialogues = jsonContextDialogueHolder.dialogues;
                ArrayList<DialogueData> dialogueData = new ArrayList<DialogueData>();
                for (JsonDialogue jsonDialogue : dialogues) {
                    DialogueInfo dialogueInfo = new DialogueInfo(contentEntry.getKey(), contextEntry.getKey(), jsonDialogue.fileOverride());
                    DialogueLineInfo lineInfo = jsonDialogue.lineInfo;
                    ResolvedDialogueSoundSettings soundSettings = this.resolveSoundSettings(jsonHolder.settings, jsonContextHolder.settings, jsonContextDialogueHolder.settings, jsonDialogue.settings);
                    dialogueData.add(new DialogueData(dialogueInfo, lineInfo, soundSettings));
                }
                contexts.put(contextEntry.getKey(), new ContextDialogueHolder(dialogueData));
            }
            content.put(contentEntry.getKey(), new DialogueContextHolder(contexts));
        }
        return new DialogueHolder(content);
    }

    private ResolvedDialogueSoundSettings resolveSoundSettings(JsonDialogueSoundSettings globalSettings, JsonDialogueSoundSettings contentSettings, JsonDialogueSoundSettings contextSettings, JsonDialogueSoundSettings dialogueSettings) {
        Boolean followPlayer = Optional.ofNullable(dialogueSettings).flatMap(JsonDialogueSoundSettings::followPlayer).or(() -> Optional.ofNullable(contextSettings).flatMap(JsonDialogueSoundSettings::followPlayer)).or(() -> Optional.ofNullable(contentSettings).flatMap(JsonDialogueSoundSettings::followPlayer)).or(() -> Optional.ofNullable(globalSettings).flatMap(JsonDialogueSoundSettings::followPlayer)).orElse(DialogueHolder.DEFAULT_SETTINGS.followPlayer().get());
        Integer falloff = Optional.ofNullable(dialogueSettings).flatMap(JsonDialogueSoundSettings::falloff).or(() -> Optional.ofNullable(contextSettings).flatMap(JsonDialogueSoundSettings::falloff)).or(() -> Optional.ofNullable(contentSettings).flatMap(JsonDialogueSoundSettings::falloff)).or(() -> Optional.ofNullable(globalSettings).flatMap(JsonDialogueSoundSettings::falloff)).orElse(DialogueHolder.DEFAULT_SETTINGS.falloff().get());
        Vector3f position = Optional.ofNullable(dialogueSettings).flatMap(JsonDialogueSoundSettings::position).or(() -> Optional.ofNullable(contextSettings).flatMap(JsonDialogueSoundSettings::position)).or(() -> Optional.ofNullable(contentSettings).flatMap(JsonDialogueSoundSettings::position)).or(() -> Optional.ofNullable(globalSettings).flatMap(JsonDialogueSoundSettings::position)).orElse(DialogueHolder.DEFAULT_SETTINGS.position().get());
        return new ResolvedDialogueSoundSettings(followPlayer, falloff, position);
    }

    private record JsonDialogueHolder(TreeMap<String, JsonDialogueContextHolder> content, JsonDialogueSoundSettings settings) {
    }

    private record JsonDialogueContextHolder(LinkedHashMap<String, JsonContextDialogueHolder> contexts, JsonDialogueSoundSettings settings) {
    }

    private record JsonContextDialogueHolder(ArrayList<JsonDialogue> dialogues, JsonDialogueSoundSettings settings) {
    }

    private record JsonDialogue(DialogueLineInfo lineInfo, JsonDialogueSoundSettings settings, String fileOverride) {
    }

    private static class JsonDialogueSoundSettings
    implements DialogueSoundSettings {
        private final Boolean followPlayer;
        private final Integer falloff;
        private final Vector3f position;

        private JsonDialogueSoundSettings(Boolean followPlayer, Integer falloff, Vector3f position) {
            this.followPlayer = followPlayer;
            this.falloff = falloff;
            this.position = position;
        }

        @Override
        public Optional<Boolean> followPlayer() {
            return Optional.ofNullable(this.followPlayer);
        }

        @Override
        public Optional<Integer> falloff() {
            return Optional.ofNullable(this.falloff);
        }

        @Override
        public Optional<Vector3f> position() {
            return Optional.ofNullable(this.position);
        }
    }
}

