/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;

public class VowLogger {
    private static final HashSet<String> addedLines = new HashSet();
    private static final String fileName = "logs/vowLog.txt";
    private static final String lastLineInDialoguePattern = "^\\[(\\d+)\\/\\1\\]\\s.*";

    public static void Initialize() {
        VowLogger.createFile();
    }

    private static void createFile() {
        try {
            File myObj = new File(fileName);
            if (myObj.createNewFile()) {
                System.out.println("File created: " + myObj.getName());
            } else {
                VowLogger.clearFile();
            }
        }
        catch (IOException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
    }

    private static void clearFile() {
        try {
            FileWriter fw = new FileWriter(fileName, false);
            PrintWriter pw = new PrintWriter((Writer)fw, false);
            pw.flush();
            pw.close();
            fw.close();
        }
        catch (Exception exception) {
            System.out.println("Exception have been caught when clearing the vowLog file");
        }
    }

    public static void logLine(String message, String logType) {
        VowLogger.writeIfDoesNotContain("[" + logType + "] " + message);
        if (VowLogger.isLastLineInDialogue(message)) {
            VowLogger.write("\n");
        }
    }

    public static void logLine(String message) {
        VowLogger.writeIfDoesNotContain(message);
        if (VowLogger.isLastLineInDialogue(message)) {
            VowLogger.write("\n");
        }
    }

    private static void writeIfDoesNotContain(String message) {
        if (!addedLines.add((String)message)) {
            return;
        }
        message = (String)message + "\n";
        VowLogger.write((String)message);
    }

    private static void write(String text) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), StandardCharsets.UTF_8);
            out.write(text);
            ((Writer)out).close();
        }
        catch (IOException e) {
            System.out.println("An error happened while writing " + text + " to the file.");
            e.printStackTrace();
        }
    }

    private static boolean isLastLineInDialogue(String message) {
        return message.matches(lastLineInDialoguePattern);
    }
}

