/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp.config;

import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="wynnvp")
public class VOWAutoConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public String word = "gzog6zilzq6zxlt";
    @ConfigEntry.Gui.Excluded
    public boolean hasChosenLineReport = false;
    @ConfigEntry.Gui.Excluded
    public String azureBlobLink = "http://voicesofwynn.blob.core.windows.net/audio/sounds/";
    @ConfigEntry.Gui.Excluded
    public List<String> urls = List.of("https://cdn.jsdelivr.net/gh/Team-VoW/WynncraftVoiceProject@main/sounds/");
    @ConfigEntry.Gui.Excluded
    public double npcFinderThingMaxDistanceChangeBeforeCacheInvalid = 0.5;
    @ConfigEntry.Gui.Excluded
    public String lastsSoundsUpdateHeader = "never";
    @ConfigEntry.Gui.Tooltip
    public boolean playAllSoundsOnPlayer = false;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=70L, max=200L)
    public int playbackSpeed = 100;
    public boolean reportMissingLines = true;
    public boolean anonymous = true;
    public boolean sendFunFact = false;
    @ConfigEntry.Gui.Tooltip
    public boolean downloadSounds = false;
    @ConfigEntry.Gui.Tooltip
    public int blockCutOff = 32;
    @ConfigEntry.Gui.Tooltip
    public boolean removeVillagerSounds = false;
    @ConfigEntry.Gui.Tooltip
    public boolean autoProgress = false;
    @ConfigEntry.Gui.Tooltip
    public boolean enableReverb = true;
    @ConfigEntry.Gui.CollapsibleObject
    public DebugAndLogs debugAndLogs = new DebugAndLogs();

    public boolean isLogDialogueLines() {
        return this.debugAndLogs.logDialogueLines;
    }

    public boolean isOnlyLogNotPlayingLines() {
        return this.debugAndLogs.onlyLogNotPlayingLines;
    }

    public boolean isLogPlayingInformation() {
        return this.debugAndLogs.logPlayingInformation;
    }

    public boolean isUseCustomAudioPath() {
        return this.debugAndLogs.useCustomAudioPath;
    }

    public String getCustomAudioPath() {
        return this.debugAndLogs.customAudioPath;
    }

    public boolean isUseCustomSoundsJson() {
        return this.debugAndLogs.useCustomSoundsJson;
    }

    public String getCustomSoundsJsonPath() {
        return this.debugAndLogs.customSoundsJsonPath;
    }

    public boolean isRemoveVillagerSounds() {
        return this.removeVillagerSounds;
    }

    public void setRemoveVillagerSounds(boolean input) {
        this.removeVillagerSounds = input;
    }

    public boolean isPlayAllSoundsOnPlayer() {
        return this.playAllSoundsOnPlayer;
    }

    public float getPlaybackSpeed() {
        return (float)this.playbackSpeed / 100.0f;
    }

    public String getWord() {
        return this.word;
    }

    public boolean isReportMissingLines() {
        return this.reportMissingLines;
    }

    public void setReportMissingLines(boolean input) {
        this.reportMissingLines = input;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean input) {
        this.anonymous = input;
    }

    public boolean isSendFunFact() {
        return this.sendFunFact;
    }

    public int getBlockCutOff() {
        return this.blockCutOff;
    }

    public boolean isHighlightSpeaker() {
        return this.debugAndLogs.highlightSpeaker;
    }

    public double getNpcFinderThingMaxDistanceChangeBeforeCacheInvalid() {
        return this.npcFinderThingMaxDistanceChangeBeforeCacheInvalid;
    }

    public boolean getHasShownMissingLineNotification() {
        return this.hasChosenLineReport;
    }

    public void setHasShownMissingLineNotification(boolean input) {
        this.hasChosenLineReport = input;
    }

    public void save() {
        AutoConfig.getConfigHolder(VOWAutoConfig.class).save();
    }

    public String getRemoteJsonLink() {
        return this.azureBlobLink + "sounds.json";
    }

    public static class DebugAndLogs {
        @ConfigEntry.Gui.Tooltip
        public boolean highlightSpeaker = false;
        @ConfigEntry.Gui.Tooltip
        public boolean logDialogueLines = true;
        @ConfigEntry.Gui.Tooltip
        public boolean onlyLogNotPlayingLines = true;
        @ConfigEntry.Gui.Tooltip
        public boolean logPlayingInformation = false;
        @ConfigEntry.Gui.Tooltip
        public boolean useCustomAudioPath = false;
        @ConfigEntry.Gui.Tooltip
        public String customAudioPath = "";
        @ConfigEntry.Gui.Tooltip
        public boolean useCustomSoundsJson = false;
        @ConfigEntry.Gui.Tooltip
        public String customSoundsJsonPath = "";
    }
}

