/*
 * Decompiled with CFR 0.152.
 */
package com.wynnvp.wynncraftvp;

import com.wynnvp.wynncraftvp.commands.DebugCommand;
import com.wynnvp.wynncraftvp.config.VOWAutoConfig;
import com.wynnvp.wynncraftvp.core.Managers;
import com.wynnvp.wynncraftvp.logging.VowLogger;
import com.wynnvp.wynncraftvp.sound.SoundPlayer;
import com.wynnvp.wynncraftvp.sound.SoundsHandler;
import com.wynnvp.wynncraftvp.sound.downloader.AudioDownloader;
import com.wynnvp.wynncraftvp.sound.downloader.ToastManager;
import com.wynnvp.wynncraftvp.sound.player.AudioPlayer;
import com.wynnvp.wynncraftvp.text.ChatHandler;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModCore
implements ModInitializer {
    public static final String MODID = "wynnvp";
    private String version;
    public static boolean inLiveWynnServer = false;
    public static boolean isUsingClothApi = false;
    public SoundsHandler soundsHandler;
    public static ModCore instance;
    public AudioPlayer audioPlayer;
    public SoundPlayer soundPlayer;
    public static ChatHandler chatHandler;
    public static VOWAutoConfig config;
    public static final Logger LOGGER;
    public AudioDownloader audioDownloader;

    public void onInitialize() {
        Optional vowMod = FabricLoader.getInstance().getModContainer(MODID);
        if (vowMod.isEmpty()) {
            ModCore.error("Mod not found by fabric.");
            return;
        }
        this.version = "v" + ((ModContainer)vowMod.get()).getMetadata().getVersion().getFriendlyString();
        LOGGER.info("Loading Voices of Wynn {} (on Minecraft {})", (Object)this.version, (Object)class_155.method_16673().comp_4025());
        Managers.initialize();
        isUsingClothApi = FabricLoader.getInstance().isModLoaded("cloth-config");
        AutoConfig.register(VOWAutoConfig.class, Toml4jConfigSerializer::new);
        config = (VOWAutoConfig)AutoConfig.getConfigHolder(VOWAutoConfig.class).getConfig();
        instance = this;
        chatHandler = new ChatHandler();
        this.soundPlayer = new SoundPlayer();
        this.soundsHandler = new SoundsHandler();
        VowLogger.Initialize();
        ClientTickEvents.END_WORLD_TICK.register(cli -> {
            chatHandler.onTick();
            if (this.audioPlayer != null) {
                this.audioPlayer.openAlPlayer.onTick();
            }
        });
        this.audioDownloader = new AudioDownloader("VOW_AUDIO");
        new ToastManager(class_310.method_1551());
        CommandRegistrationCallback.EVENT.register(DebugCommand::register);
    }

    public static void error(String msg) {
        LOGGER.error(msg);
    }

    public static void error(String msg, Throwable t) {
        LOGGER.error(msg, t);
    }

    public static void warn(String msg) {
        LOGGER.warn(msg);
    }

    public static void warn(String msg, Throwable t) {
        LOGGER.warn(msg, t);
    }

    public static void info(String msg) {
        LOGGER.info(msg);
    }

    public String getVersion() {
        return this.version;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MODID);
    }
}

